// -*- coding: utf-8 -*-
/**
 @file      main.cpp
 @brief     Sample for "GPS_INT" library
 
 @author    D.Nakayama
 @version   1.0
 @date      2018-07-12  D.Nakayama  Written for C++/mbed.
 
 
 @see 
 Copyright (C) 2018 D.Nakayama.
 Released under the MIT license.
 http://opensource.org/licenses/mit-license.php
 using device Nucleo-F401RE and GMS7-CR6
*/

#include "mbed.h"
#include "GPS_INT.h"
#include "MODSERIAL.h"

MODSERIAL pc(USBTX, USBRX); // tx, rx 
GPS_INT gps(D8, D2);   // tx, rx

int main() {
    printf("hello gps!\n");
    while(1) {
        if(gps.location_is_update()){
            printf("UTC       :%04d/%02d/%02d %02d:%02d:%02d\n",gps.t.tm_year + 1900, gps.t.tm_mon + 1, gps.t.tm_mday, gps.t.tm_hour, gps.t.tm_min, gps.t.tm_sec);
            printf("longitude :%f\n",gps.lon);
            printf("latitude  :%f\n",gps.lat);
            printf("PDOP      :%.1f\n",gps.PDOP);
            printf("HDOP      :%.1f\n",gps.HDOP);
            printf("VDOP      :%.1f\n",gps.VDOP);
            printf("lock      :%d\n",gps.lock);
            printf("n_sat     :%d\n",gps.n_sat);
            printf("h_see     :%.1f\n",gps.h_see);
            printf("h_geo     :%.1f\n",gps.h_geo);
            printf("\n");
        }
    }
}
