// -*- coding: utf-8 -*-
/**
 @file      i2c_general_io.cpp
 @brief     This is a library for accessing registers of a typical i2c sensor to set or read measurement value.
 
 @author    D.Nakayama
 @version   1.0
 @date      2018-07-08  D.Nakayama  Written for C++/mbed.
 
 
 @see 
 Copyright (C) 2018 D.Nakayama.
 Released under the MIT license.
 http://opensource.org/licenses/mit-license.php
 
*/

#include "i2c_general_io.h"
#include "mbed.h"


GEN_I2C::GEN_I2C(PinName sda, PinName scl)
    :
    i2c_p(new I2C(sda, scl)), 
    i2c(*i2c_p)
{
}

GEN_I2C::GEN_I2C(I2C &i2c_obj)
    :
    i2c_p(NULL), 
    i2c(i2c_obj)
{
}

GEN_I2C::~GEN_I2C()
{
    if (NULL != i2c_p)
        delete  i2c_p;
}

//multi bytes read
int GEN_I2C::read_reg(char Device_add, char reg_add, char *data, int n){

    int result;

    i2c.write(Device_add,&reg_add,1);
    result = i2c.read(Device_add|1,data,n);
    
    return result;
}

//single byte read
char GEN_I2C::read_reg(char Device_add, char reg_add){

    char result = 0xFF;

    i2c.write(Device_add,&reg_add,1);
    i2c.read(Device_add|1,&result,1);
    
    return result;

}

//single byte write
int GEN_I2C::write_reg(char Device_add, char reg_add, char data){

    int result;
    char cmd[2];
    
    cmd[0] = reg_add;
    cmd[1] = data;

    result = i2c.write(Device_add,cmd,2);

    return result;
}
