// -*- coding: utf-8 -*-
/**
 @file      BME280_reg.h
 @brief     MBE280の内部レジスタのアドレスや入力すべき定数などについての定義
 
 @author    D.Nakayama
 @version   1.0
 @date      2018-07-10  D.Nakayama  Written for C++/mbed.
 
 
 @see 
 Copyright (C) 2018 D.Nakayama.
 Released under the MIT license.
 http://opensource.org/licenses/mit-license.php
 
*/

#ifndef BME280_REG_H
#define BME280_BME280_REG_H

//コンストラクタに入れる定数の定義終わり

    //測定動作モード
    #define BME280_SLEEP_MODE         0x00
    #define BME280_FORCE_MODE         0x02
    #define BME280_NORMAL_MODE        0x03

    //気圧のオーバーサンプリング制御
    #define BME280_PRESS_SKIP         0x00
    #define BME280_PRESS_OVER_SAMPL1  (0x01<<2)
    #define BME280_PRESS_OVER_SAMPL2  (0x02<<2)
    #define BME280_PRESS_OVER_SAMPL4  (0x03<<2)
    #define BME280_PRESS_OVER_SAMPL8  (0x04<<2)
    #define BME280_PRESS_OVER_SAMPL16 (0x05<<2)

    //温度のオーバーサンプリング制御
    #define BME280_TEMP_SKIP          0x00
    #define BME280_TEMP_OVER_SAMPL1   (0x01<<5)
    #define BME280_TEMP_OVER_SAMPL2   (0x02<<5)
    #define BME280_TEMP_OVER_SAMPL4   (0x03<<5)
    #define BME280_TEMP_OVER_SAMPL8   (0x04<<5)
    #define BME280_TEMP_OVER_SAMPL16  (0x05<<5)

    //湿度のオーバーサンプリング制御
    #define BME280_HUM_SKIP           0x00
    #define BME280_HUM_OVER_SAMPL1    0x01
    #define BME280_HUM_OVER_SAMPL2    0x02
    #define BME280_HUM_OVER_SAMPL4    0x03
    #define BME280_HUM_OVER_SAMPL8    0x04
    #define BME280_HUM_OVER_SAMPL16   0x05

    //IIRフィルタの時定数設定
    #define BME280_IIR_OFF            0x00
    #define BME280_IIR_2              (0x01<<2)
    #define BME280_IIR_4              (0x02<<2)
    #define BME280_IIR_8              (0x03<<2)
    #define BME280_IIR_16             (0x04<<2)

    //測定後休止時間設定（ノーマルモードのみ有効）
    #define BME280_NORMAL_STANBY_0_5  0x00
    #define BME280_NORMAL_STANBY_62_5 (0x01<<5)
    #define BME280_NORMAL_STANBY_125  (0x02<<5)
    #define BME280_BME280_NORMAL_STANBY_250  (0x03<<5)
    #define BME280_NORMAL_STANBY_500  (0x04<<5)
    #define BME280_NORMAL_STANBY_1000 (0x05<<5)
    #define BME280_NORMAL_STANBY_10   (0x06<<5)
    #define BME280_NORMAL_STANBY_20   (0x07<<5)

//コンストラクタに入れる定数の定義終わり


//デバイスアドレス8bit
    #define BME280_add  0x76<<1

//レジスタアドレス

    //データ読み込みレジスタ
    /*           
    #define BME280_HUM_LSB     0xFE
    #define BME280_HUM_MSB     0xFD
    #define BME280_TEMP_XLSB   0xFC
    #define BME280_TEMP_LSB    0xFB
    #define BME280_TEMP_MSB    0xFA
    #define BME280_PRESS_XLSB  0xF9
    #define BME280_PRESS_LSB   0xF8
    */
    #define BME280_PRESS_MSB   0xF7

    //設定系レジスタ
    #define BME280_CONFIG      0xF5
    #define BME280_CTRL_MEAS   0xF4
    #define BME280_STATUS      0xF3
    #define BME280_CTRL_HUM    0xF2
    #define BME280_RESET_REG   0xE0
    #define BME280_ID          0xD0

    //補正係数格納レジスタ(読み込みのみ)
    #define BME280_CALIB00     0x88
    #define BME280_CALIB25     0xA1
    #define BME280_CALIB26     0xE1               


//ID
    //IDの規定値(BME280_IDを読むといつもこの値,ハードウエアの接続確認用)
    #define BME280_ID_VALUE    0b01100000

//RESET
    //リセットをかけるための値(BME280_RESET_REGに書き込むとリセットがかかる)
    #define BME280_RESET_VALUE 0xB6


//STATUS判定式
    //測定中の判定式
    #define BME280_STATUS_IS_MEASURING (sensor.read_reg(BME280_add,BME280_STATUS) & 0x08)
    //コピー中
    #define BME280_STATUS_IS_COPYING   (sensor.read_reg(BME280_add,BME280_STATUS) & 0x01)

#endif