

#include "main.h"
/**
* @file main.cpp
* 
* 
* @brief  code information
* The code is written with numerous start and end positions of code class.
* This made debugging much easier and will be used as a standard of practice 
* for future work.
* 
* @author Jeremy Ogus
*
* @version 1.2.2
*
* @date 10/05/2015
*
*
*v1.0 - broken code in separate loops
*v1.1 - main game in working fashion, no bugs
*v1.2 - power saving and multi directional joystick included, 8 way
*v1.2.1 - pause system now flawless
*v1.2.2 - harder game, borders more efficient
*
*____________________________________________________Definitions and inputs START_____________________________________________________________________
*/

/*
*___________________________________________________Pause game interrupt END______________________________________________________________________
*
*
*
*______________________________________________________Main code loop START_____________________________________________________________________
*/

int main(){

//turns off ethernet ports 
PHY_PowerDown(); 


//pause button interrupt
buttonB.fall(&enable);



/*    
*_______________________________________________________Intro sequence START_____________________________________________________________________
*/
   
    wait(0.3);
    led1 = 1; //oount up LED sequence
    wait(0.2);
    led2 = 1;
    wait(0.2);
    led3 = 1;
    wait(0.2);
    led4 = 1;
    wait(0.5);
    
    led1 = 0;//LED flashing
    led2 = 0;
    led3 = 0;
    led4 = 0;
    wait(0.1);
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    wait(0.1);
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    wait(0.1);
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    wait(0.1);
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0; 
    

   
    //LCD initialisation + power
    lcd.init();
    void clearBuffer();
buzzer.period(0.05); //pwm period
buzzer = 0.8;       //duty cyle    
    
wait(0.2);
buzzer.period(0.05);
buzzer = 0;
    
    wait(0.1);
    lcd.normalMode();      // normal colour mode
        lcd.setBrightness(1); // put LED backlight on 100%      
    lcd.printString("Let's Play..",8,3);  //intro 
        wait(1.25);
    
    lcd.clear(); //clear current display 
    
        lcd.inverseMode(); //white on black mode
    lcd.printString("METEOR",26,2); //game title
    lcd.printString("DODGER",26,4); 
        wait(2.25);
    
    lcd.clear(); //clear display again
    lcd.normalMode();      

/*    
*______________________________________________Replay cuts into code here => getTo theChopper;___________________________________________
*/
    
  theChopper:
  wait(0.01); 
    
    
    buttonA.mode(PullUp);
    buttonB.mode(PullUp);
    
    
    lcd.printString("Press button A",0,2);
    lcd.printString("to start!",16,4);
    
    
/*____________________________________________________Intro sequence END_____________________________________________________________________
*
*
*
*____________________________________________________Game loop START_________________________________________________________________________
*/

//wait until A is pushed

while(buttonA==1){
    }    

    lcd.clear();

        
    //  character spawn 
    pxpos = 42;
    pypos = 32;
    lcd.drawCircle(pxpos,pypos,5,0);  
    lcd.refresh();


    calibrateJoystick();  // get centred values of joystick

    pollJoystick.attach(&updateJoystick,1.0/20.0);  // read joystick 20 times per second
    
//Border rules START  
    while(1){
        
        for(int i=0;i<=47;i++){
            lcd.setPixel(0,i);
            lcd.setPixel(83,i);  
        }
        for(int j=0;j<=83;j++){
            lcd.setPixel(j,0);
            lcd.setPixel(j,47);
        }
            
    lcd.refresh();

//Border rules END
    
     if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
/*
*    middle "if" loop enables border rules, only move if character pixels are outside the border limit
*   main if loop moves position 2 pixels in relevant direction
*/            

            // check joystick direction
            if (joystick.direction == UP)
                {if(pypos>7){
                pypos = pypos-2;}}
            
            if (joystick.direction == DOWN)
                {if(pypos<40){
                pypos = pypos+2;}}
            
            if (joystick.direction == LEFT)
                {if(pxpos>7){
                pxpos = pxpos-2;}}
            
            if (joystick.direction == RIGHT)
                {if(pxpos<76){
                pxpos = pxpos+2;}}
                
            if (joystick.direction == UP_RIGHT)
                {if((pypos>7)&&(pxpos<76)){
                pxpos = pxpos+2;
                pypos = pypos-2;}}
                
            if (joystick.direction == UP_LEFT)
                {if((pxpos>7)&&(pypos>7)){
                pxpos = pxpos-2;
                pypos = pypos-2;}}
                
            if (joystick.direction == DOWN_RIGHT)
                {if((pxpos<76)&&(pypos<40)){
                pxpos = pxpos+2;
                pypos = pypos+2;}}
                
            if (joystick.direction == DOWN_LEFT)
                {if((pxpos>7)&&(pypos<40)){
                pxpos = pxpos-2;
                pypos = pypos+2;}}

/* 
UNNEEDED FOR CURRENT VERSION         
            if (joystick.direction == CENTRE)
                {}
            
            if (joystick.direction == UNKNOWN)
                
                {}   
*/         
       
    }
   
    //user drawing     
    lcd.drawCircle(pxpos,pypos,5,0);  //USER
    
    lcd.refresh();
    
    
/*  
*____________________________________________________Hostile AI START_____________________________________________________________________
*/  
  
   
   if(meteorstart ==1){
       
       meteorstart = 0;
   srand(time(NULL));
   
    for(int q=0;q<=4;q++){              //do for all 5 AI
    
    mxpos[q]=(rand()%83);                   //random generation
    
    
    mypos[q]=0;
    lcd.drawCircle(mxpos[q],mypos[q],2,1);  // x,y,radius,black fill
    
    
    }
    }
    else{
        
      for(int q=0;q<=4;q++){        //for all 5 AI
    
    if (mypos[q] <=45){             //continue downward, if less than 45
        
    mypos[q]=mypos[q]+3;        //drop speed
    lcd.drawCircle(mxpos[q],mypos[q],2,1);  // x,y,radius,black fill
    }
    else{
        meteorstart = 1;
        }
    
    
    }
    }  


    for(int k = 0; k<=4;k++){               //if collision has occured
     if((abs(pxpos - mxpos[k])<7)){
         if((abs(pypos - mypos[k]))<7){
         magchange = 1;
         }
        }
         
    } 
           
         if(magchange == 1){
             break;

             }
           


   
    lcd.refresh();    
    wait(0.1);//wait before spawn    MUST be less than 0.1, affects refresh rate of anim + movement
    lcd.clear();
    
    

//____________________________________________________Hostile AI END_____________________________________________________________________
}
    
    
/* 
ESSENTIAL!  
following two statements enable initial code states, allowing the code to
execute game loop properly
*/
    meteorstart = 1;
    magchange = 0;
    

   
             lcd.clear();
             lcd.printString("GAME OVER!",14,2);
             
buzzer.period(0.05); //pwm period
buzzer = 0.8;       //duty cyle    
    

             wait(0.5);
             lcd.inverseMode();
             wait(0.25);
             lcd.normalMode();
             
buzzer.period(0.05);
buzzer = 0; 

             wait(0.25);
             lcd.inverseMode();
             wait(0.25);
             lcd.normalMode();
             wait(0.25);
             lcd.inverseMode();
             wait(0.25);
             lcd.normalMode();
             wait(0.5);
             lcd.clear();
             wait(0.1);
  


//inactivity timer, put to sleep if not replaying within 15 seconds
            
             goneFishing.start();
             
             lcd.printString("Press button A",0,2);
             lcd.printString("to replay..",10,4);
             
             lcd.refresh();
        
        
        while(buttonA==1){
                    
                    if(goneFishing.read()>10){
                        lcd.setBrightness(0.25);
                        }
                                               
                    if(goneFishing.read()> 11.25){
                       DeepPowerDown();
                        }
                    }
                    
                goneFishing.stop();
                goneFishing.reset();     
             
                       
                lcd.clear();
                lcd.setBrightness(1);
                getTo theChopper;
                          

//____________________________________________________Game loop END_____________________________________________________________________       


}
//____________________________________________________Main code loop END_____________________________________________________________________
