#ifndef SHORTRANGESENSOR_H
#define SHORTRANGESENSOR_H

#include "mbed.h"

//constants for i2c communication
const int ADDR = 0x52;
const char SYSRANGE__START_SAMPLE[] = {0x00,0x18,0x01};
const char RESULT__RANGE_VAL[] = {0x00,0x62};
const char RESULT__RANGE_STATUS[] = {0x00,0x4D};
const char SYSRANGE__RANGE_CHECK_ENABLES[] = {0x00,0x2D,0x10};
const char SYSRANGE__PART_TO_PART_RANGE_OFFSET_INIT[] = {0x00,0x24,0x00}; //once correct offset is found, chage 0x00 to correct offset
const char SYSRANGE__PART_TO_PART_RANGE_OFFSET[] = {0x00,0x24};

class ShortRangeSensor
{
    public:
    ShortRangeSensor(PinName sda, PinName scl);
    //returns range in mm
    int getRange();
    //returns value of status register
    int getStatus();
    //returns value of part to part range offset register
    int getPPOffset();
    //sets value of part to part range offset register, -128 to 128
    void setPPOffset(int offset);
    
    private:
    I2C i2c;
};

#endif