#ifndef __LAYOUT_H
#define __LAYOUT_H

#define PWMA PA_9
#define PWMB PA_10
#define PWMC PA_8
#define EN PB_15

#define IA PB_0
#define IB PC_1

#define TH_PIN PB_8
#define RESOLVER_RESET PC_7

#define LOG_TX PC_10
#define LOG_RX PC_11

#define STATUS_LED PB_14

#define I_SCALE_RAW 25.0f //mv/A
#define R_UP 12000.0f //ohms
#define R_DOWN 3600.0f //ohms
#define R_BIAS 3600.0f //ohms
#define AVDD 3300.0f //mV

/*allows for inverting power modules*/
#define set_dtc(phase, value) *phase = 1.0f - (value)

/*inverter linearity limit*/
#define LINEAR_DTC_MAX 0.945f

//don't change these!
#define I_OFFSET (AVDD * R_DOWN * R_UP / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))
#define I_SCALE (R_BIAS * R_DOWN * I_SCALE_RAW / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))

#define PI 3.141593f

#endif