#ifndef __DEFAULTS_H
#define __DEFAULTS_H

/*---driving (mostly unimplemented)---*/

/*legacy code, indicating there should be no throttle map*/
#define TORQUE_MODE true

/*forward torque scaling*/
#define MAX_TQPCT_PLUS 1.0f

/*reverse/regen torque scaling*/
#define MAX_TQPCT_MINUS 0.3f

/*maximum torque for approximate methods*/
#define TORQUE_MAX 75.0f

/*max speed, including any field weakening, rad/s*/
#define W_MAX 1000.0f

/*---inverter---*/

/*DC link voltage, volts*/
#define BUS_VOLTAGE 160.0f

/*switching frequency, hertz*/
#define F_SW 5000.0f

/*propagation delay swizzle factor (+w_m / V_PHASE_SWIZZLE)*/
#define V_PHASE_SWIZZLE 1048.0f

/*---logging---*/

#define ENABLE_LOGGING true

#define LOG_PAGE_SIZE 4096
#define LOG_HEADER_SIZE 10
#define LOG_PACKET_SIZE 8
#define LOG_BAUD_RATE 921600

/*---loop---*/
#define K_LOOP_D 0.75f
#define KI_BASE_D 0.025f

#define K_LOOP_Q 1.75f
#define KI_BASE_Q 0.01f

#define F_SLOW_LOOP 50.0f

#define INTEGRAL_MAX 1.5f
#define OVERMODULATION_FACTOR 0.5f

/*filter strengths, 0-1.0
  higher = stronger filtering*/
#define DQ_FILTER_STRENGTH 0.80f

/*windows for median filtering*/
#define THROTTLE_FILTER_WINDOW 7
#define W_FILTER_WINDOW 3

/*---motor---*/

/*# of pole pairs*/
#define POLE_PAIRS 3.0f

/*electrical position offset,
  measured as +a, -b, -c (radians)*/
#define POS_OFFSET 5.7614f

/*# of resolver lobes*/
#define RESOLVER_LOBES 3.0f

/*CPR of encoder or encoder emulator*/
#define CPR 4096

/*d and q axis inductances, henries*/
#define Ld 0.000605f
#define Lq 0.001536f

/*PM flux linkage, volt-seconds*/
#define FLUX_LINKAGE 0.0529f

/*single phase resistance, ohms*/
#define Rs 0.05f

/*torque/phase amp for approximate models*/
#define KT 0.3f

/*a safe speed below which you 
  never need to field weaken*/
#define W_SAFE 100.0f

/*maximum sane mechanical speed,
  used to filter velocity (rad/s)*/
#define W_CRAZY 2000.0f

/*---rc throttle---*/

#define TH_PIN PB_8
#define TH_LIMIT_LOW 1520//1050 //1520 //uS
#define TH_LIMIT_HIGH 1720//1950 //1720

/*---table---*/

#define W_STEP 150.f

/*---speed mode---*/

#define K_LOOP_W 0.0f
#define KI_BASE_W 0.0f
#define W_SETPOINT_MAX 1500.0f
#define W_LOOP_MAX_TQ 1.0f

#endif