#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"

#include "globals.h"

void processCmd(Serial *pc, PreferenceWriter *pref, char *buf) {
    io.cmd_busy = true;
    
    char *tokens[10];
    int len = tokenize(buf, tokens, 10);
    
    switch (len) {
    case 1:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls(pc);
        else if (strcmp(tokens[0], "defaults") == 0) cmd_defaults(pc);
        else if (strcmp(tokens[0], "reload") == 0) cmd_reload(pc, pref);
        else if (strcmp(tokens[0], "load") == 0) cmd_reload(pc, pref);
        else if (strcmp(tokens[0], "flush") == 0) cmd_flush(pc, pref);
        else if (strcmp(tokens[0], "mode") == 0) cmd_ls2(pc, tokens[0]);
        else if (strcmp(tokens[0], "src") == 0) cmd_ls2(pc, tokens[0]);
        else if (strcmp(tokens[0], "op") == 0) cmd_ls2(pc, tokens[0]);
        else if (strcmp(tokens[0], "run") == 0) cmd_mode(pc, tokens[0]);
        else if (strcmp(tokens[0], "cfg") == 0) cmd_mode(pc, tokens[0]);
        else if (strcmp(tokens[0], "zero") == 0) cmd_mode(pc, tokens[0]);
        else if (strcmp(tokens[0], "wizard") == 0) cmd_mode(pc, tokens[0]);
        else if (strcmp(tokens[0], "exit") == 0) cmd_exit(pc);
        else if (strcmp(tokens[0], "clear") == 0) cmd_clear(pc);
        else pc->printf("%s\n", "Bad command");
        break;
    case 2:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls2(pc, tokens[1]);
        else if (strcmp(tokens[0], "get") == 0) cmd_ls2(pc, tokens[1]);
        else if (strcmp(tokens[0], "setp") == 0) cmd_setp(pc, tokens[1]);
        else if (strcmp(tokens[0], "mode") == 0) cmd_mode(pc, tokens[1]);
        else if (strcmp(tokens[0], "src") == 0) cmd_src(pc, tokens[1]);
        else if (strcmp(tokens[0], "op") == 0) cmd_op(pc, tokens[1]);
        else if (strcmp(tokens[0], "query") == 0) cmd_query(pc, tokens[1]);
        else pc->printf("%s\n", "Bad command");
        break;
    case 3:
        if (strcmp(tokens[0], "set") == 0) cmd_set(pc, tokens[1], tokens[2]);
        else pc->printf("%s\n", "Bad command");
        break;
    default:
        pc->printf("%s\n", "Bad command");
        break;
    }
    
    io.cmd_busy = false;
}

void processCmdFast(Serial *pc, PreferenceWriter *pref, char *buf) {
    io.cmd_busy = true;
    
    switch (buf[0]) {
    case 128:
        cmdf_setp(pc, buf[1]);
        break;
    case 129:
        cmdf_w(pc);
        break;
    case 130:
        cmdf_data(pc);
        break;
    default:
        break;
    }
    
    io.cmd_busy = false;
}