#include "BufferedLogger.h"

BufferedLogger::BufferedLogger(int packet_size, int buffer_size, PinName tx, PinName rx, int rate) {
    _log = new Serial(tx, rx);
    _log->baud(rate);
    
    _packet_size = packet_size;
    _buffer_size = buffer_size;
    _page_size = (_packet_size + 1) * _buffer_size;
    
    _buf1 = (unsigned char*)malloc((_page_size + _packet_size + 1)*sizeof(unsigned char));
    _buf2 = (unsigned char*)malloc((_page_size + _packet_size + 1)*sizeof(unsigned char));
    
    _front = _buf1;
    _back = _buf2;
    _index = 0;
    
    _enabled = true;
}

int BufferedLogger::log(float *pkt) {
    if (!_enabled) return 1;
    _front[_index] = 0xff;
    _index++;
    for (int i = 0; i < _packet_size; i++) {
        _front[_index + i] = __clip(pkt[i]);
    }
    _index += _packet_size;
    if (_index >= _page_size + _packet_size + 1) {
        _index = 0;
        return 0;
    }
    return 1;
}

int BufferedLogger::log(unsigned char *pkt) {
    if (!_enabled) return 1;
    _front[_index] = 0xff;
    _index++;
    for (int i = 0; i < _packet_size; i++) {
        _front[_index + i] = __clip(pkt[i]);
    }
    _index += _packet_size;
    if (_index >= _page_size + _packet_size + 1) {
        _index = 0;
        return 0;
    }
    return 1;
}

void BufferedLogger::flush() {
    if (_index >= _page_size) {
        _index = 0;
        _tmp = _front;
        _front = _back;
        _back = _tmp;
        for (int i = 0; i < _page_size; i++) _log->putc(_back[i]);
    }
}

unsigned char __clip(float x) {
    unsigned char u = (unsigned char) x;
    if (u >= 0xff) u = 0xfe;
    return u;
}

unsigned char __clip(unsigned char x) {
    unsigned char u = x;
    if (u >= 0xff) u = 0xfe;
    return u;
}