#ifndef __BREMS_STRUCTS_H
#define __BREMS_STRUCTS_H

#include "mbed.h"

#include "FastPWM.h"
#include "PwmIn.h"
#include "PositionSensor.h"
#include "BufferedLogger.h"
#include "PreferenceWriter.h"
#include "Filter.h"
#include "LedBlinker.h"

typedef struct {
    FastPWM *a, *b, *c;
    DigitalOut *en;
    PwmIn *throttle_in;
    PositionSensorEncoder *pos;
    Serial *pc;
    PreferenceWriter *pref;
    BufferedLogger *logger;
    LedBlinker *blink;
    bool cmd_busy;
} IOStruct;

typedef struct {
    float adval1, adval2, adval3;
    float vbus;
    float p_mech, last_p_mech, w;
    float ad1_supp_offset, ad2_supp_offset;
} ReadDataStruct;

typedef struct {
    float ia, ib, alpha, beta, d, q, vd, vq, valpha, vbeta, p;
    float vd_decouple, vq_decouple;
} FOCStruct;

typedef struct {
    float d_integral, q_integral;
    float last_d, last_q;
    float d_ref, q_ref;
    float d_filtered, q_filtered;
    float user_cmd;
    float torque_percent;
    float w_integral;
    MedianFilter *throttle_filter, *velocity_filter;
    bool enabled;
} ControlStruct;
    
#endif