#include "mbed.h"
#include "PwmIn.h"
#include "MathHelpers.h"

PwmIn::PwmIn(PinName pin, int usec_min, int usec_max)
{
    int_in = new InterruptIn(pin);
    dig_in = new DigitalIn(pin);
    int_in->rise(this, &PwmIn::handle_rise);
    int_in->fall(this, &PwmIn::handle_fall);
    this->usec_min = usec_min;
    this->usec_max = usec_max;
    
    usecs = usec_min;
    blocked = false;
    enabled = false;
    risen = false;
}


bool PwmIn::get_enabled()
{
    return enabled;
}

void PwmIn::handle_rise()
{
    if (!enabled) {
        enabled = true;
        usecs = usec_min;
    }
    risen = true;
    
    timer.stop();
    timer.reset();
    timer.start();
}

void PwmIn::handle_fall()
{
    if (!risen) return;
    risen = false;
    
    if (blocked) {
        blocked = false;;
        return;
    }
    
    usecs = timer.read_us();
    timer.stop();
    timer.reset();
    timer.start();
}

float PwmIn::get_throttle()
{
    if(timer.read_us() > 40000) {
        enabled = false;
        usecs = usec_min;
    }
    if(!enabled) return 0;
    return constrain(map((float)usecs, usec_min, usec_max, 0, 1), 0, 1);
}

