#ifndef __LEDBLINKER_H
#define __LEDBLINKER_H

#include "mbed.h"

class LedBlinker {
public:
    LedBlinker(PinName p, float sample_frequency, float code_frequency);
public:
    void set_code(uint8_t code);
    void update();
private:
    uint8_t _code;
    
    uint32_t _tics_per_code, _tics_per_bit;
    
    uint32_t _counter;
    uint8_t _bit;
    DigitalOut *_led;
};

#endif