#ifndef __FILTER_H
#define __FILTER_H

#include "mbed.h"
#include "math.h"

class fCircularBuffer {
public:
    fCircularBuffer(int length, bool use_median);
    float oldest() {if (oldest_index >= 0) return buf[oldest_index]; return 0.0f;}
    float newest() {if (newest_index >= 0) return buf[newest_index]; return 0.0f;}
    int length() {return _length;}
    void add(float x); /*recomputes mean, median - O(length) time*/
    float &at(int index);
public:
    float &operator[](int index) {return at(index);}
public:
    /*O(1) time*/
    float mean();
    float median();
private:
    int _length;
    bool _use_median;
    int oldest_index, newest_index, num;
    float sum;
private:
    float *buf;
    float *sorted;
};

class Filter {
public:
    virtual float update(float x) = 0;
};

class MedianFilter : public Filter {
public:
    MedianFilter(int length);
    virtual float update(float x);
private:
    fCircularBuffer *buf;
};

class MovingAverageFilter : public Filter {
public:
    MovingAverageFilter(int length);
    virtual float update(float x);
private:
    fCircularBuffer *buf;
};

#endif
