#include "main.h"
#include <mbed.h>
#include <TextLCD.h>
#include <keypad.h>

//Serial communication to PC
Serial pc (USBTX, USBRX);
//I2C I2C Setup
I2C i2c_lcd (D14, D15);  // D14 = SDA, D15 = SCL
TextLCD_I2C lcd(&i2c_lcd, 0x70, TextLCD::LCD16x4);//LCD16x4, I2C write addr = 0x70

//PwmOut contrast(PC_5); /***********/
DigitalOut contrast(PC_6); /* Contrast pin */
DigitalOut relay_one(PB_14); /* Relay pin */
DigitalOut relay_two(PB_13); /*from 12 to 13*/
AnalogIn A1Pin(PA_1);
//***///
InterruptIn event_one(PD_2); /* Interupt Fix*/
DigitalIn testIRQ(PC_9); /*Test*/

AnalogIn pm(PA_0);
zc_set zc;
relay_set rl;
level_trigger lt;
Timer timer;

const char Keytable[] = { '1', '2', '3', 'A',
                          '4', '5', '6', 'B',
                          '7', '8', '9', 'C',
                          '*', '0', '#', 'D'
                        };
volatile uint8_t kp = 'z', old_kp = 'x', keypress = 0;
Keypad keypad(D9, D8, D7, D6, D5, D4, D3, D2);
short contrast_val = 5;
bool update = true;


int main()
{

    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.locate(0, 0);
    lcd.setMode(TextLCD_I2C::DispOn);
    lcd.setBacklight(TextLCD_I2C::LightOn);
    // contrast.period(4.0f);
    //contrast = 0.0f;
    contrast.write(1); 
    relay_one.write(0);
    relay_two.write(0);
    timer.start();
    structsinit();

    //keypad.Stop();
    do {
        //printf("%.1f\r",current_dc_level());
        if (update == true) {
            Menu(false, 1, 3);
            update = false;
        }
    } while(1);
}

void keypad_read(bool reset)
{
    static unsigned long previous_millis = 0;
    unsigned long current_millis = timer.read_ms();
    const int interval = 1000;

    if (kp != old_kp) {
        old_kp = kp;
        keypress = kp;

    } else if (((current_millis - previous_millis) >= interval) && (kp == old_kp)) {
        previous_millis = current_millis;
        keypress = kp;
    }

    printf("value of keypress %c\r\n", keypress);
    if (reset) {
        keypress = NULL, kp = NULL;
    }
    keypad.Start();
}

uint32_t cbAfterInput(uint32_t index)
{
    keypad.Stop();
    kp = Keytable[index];
    update = true;
    keypad.Start();
    return 0;
}

void Menu(bool return_from_second, short to_menu, short to_second_menu)
{
    //keypad_read(0);
    const short MenuMax = 3, MenuMin = 0;
    static short PrimaryMenu = 1, SecondMenu = 5;

    if (return_from_second == true) {
        PrimaryMenu = to_menu;
        SecondMenu = to_second_menu;
    }
    //Left

    else if(kp == '*' && PrimaryMenu >= MenuMin && PrimaryMenu < MenuMax) {
        PrimaryMenu++;
    }
    //Right
    else if(kp == '#' && PrimaryMenu > MenuMin && PrimaryMenu <= MenuMax) {
        PrimaryMenu--;
    } else if((kp == '0') && (SecondMenu != PrimaryMenu)) {
        SecondMenu = PrimaryMenu;
    } else if ((kp == '0') && (SecondMenu == PrimaryMenu)) {
        Menu(true, PrimaryMenu, 5);
    }

    switch(PrimaryMenu) {
        case 0:
            DisplayWrite(3, 0, "Zero Cross", true);
            DisplayWrite(0, 3, "<*     <0> ", false);
            break;
        case 1:
            DisplayWrite(5, 0, "Relay", true);
            DisplayWrite(0, 3, "<*     <0>    #>", false);
            break;
        case 2:
            DisplayWrite(1, 0, "Level Trigger", true);
            DisplayWrite(0, 3, "<*     <0>    #>", false);
            break;
        case 3:
            DisplayWrite(4, 0, "Contrast", true);
            DisplayWrite(7, 3, "<0>    #>", false);
            break;
    }
    switch(SecondMenu) {
        case 0:
            DisplayWrite(0, 0, "A) Time+(    )Ms", false);

            if (kp == 'A') {
                kp = 'z';
                DisplayWrite(0, 3, "A) to Confirm", false);
                while (kp != 'A') {
                    update_timer(relay_timer());
                }
            } else {
                zc.timer_set = relay_timer();
                lcd.locate(9, 0);
                lcd.printf("    ");
                lcd.locate(9, 0);
                lcd.printf("%.1f", zc.timer_set);
            }
            if (kp == 'B') {
                kp = 'z';
                zc.set = !zc.set;
                lt.on_off = false;
            }
            if (zc.set == true) {
                DisplayWrite(0, 1, "B) ON/OFF   [ON]", false);
            } else {
                DisplayWrite(0, 1, "B) ON/OFF  [OFF]", false);
            }
            DisplayWrite(0, 2, "C) Delay    +( s)", false);
            if(kp == 'C') {
                kp = 'z';
                DisplayWrite(0, 3, "C) to Confirm", false);
                while (kp != 'C') {
                    delay_s();
                    wait_ms(10);
                    lcd.locate(13, 2);
                    lcd.setCursor(TextLCD_I2C::CurOn_BlkOn);
                    lcd.printf("  ");
                    lcd.locate(13, 2);
                    lcd.printf("%ds", rl.delay_val_s);
                }
                lcd.setCursor(TextLCD_I2C::CurOff_BlkOff);

            } else {
                lcd.locate(13, 2);
                lcd.printf("%ds", rl.delay_val_s);
            }
            DisplayWrite(0, 3, "<0> To Return", false);
            break;
        case 1: /* Zero Crossing activated by default */
            static bool case1state1 = false, case1state2 = false;
            DisplayWrite(0, 0, "(1)RLY1[  ] (  )", true); /* Rly1 [Funktion] (Delay)*/
            if(zc.set == true) {
                lcd.locate(8, 0);
                lcd.printf("ZC");
            } else if(lt.on_off == true) {
                lcd.locate(8, 0);
                lcd.printf("DC");
            }
            lcd.locate(13, 0);
            lcd.printf("%ds", rl.delay_val_s);
            if ((kp == '1') && (case1state1 == false)) {
                kp = 'z';
                if ((zc.set == true) && (zc.on_off == false)) { /* Activate on ZC */
                    relay_timer_countdown(true);
                    lcd.locate(12, 0);
                    lcd.printf("(ON)");
                    zc.on_off = true;
                    int_on_off();

                } else if((zc.set == true) && (zc.on_off == true)) { /*release relay if ZC is on*/
                    zc.on_off = false;
                    relay_one.write(rl.relay_one);
                    lcd.locate(11, 0);
                    lcd.printf("(OFF)");
                } else if((lt.on_off == true) && (zc.set == false)) { /* Activate on DC level */
                    relay_timer_countdown(true);
                    DisplayWrite(0, 3, "<A> To Stop", false);
                    do {
                        dc_level_run();
                    } while ((kp != 'A') && (lt.triggered == false));
                    if (kp == 'A') {
                        kp = 'z';
                        lcd.locate(11, 0);
                        lcd.printf("(OFF)");
                       // case1state1 = true;
                        Menu(false, 1, 3);
                    }
                    case1state1 = true;
                }

                else if((zc.set == false) && (lt.on_off == false)) { /* Else just activate */
                    case1state1 = true;
                    relay_timer_countdown(true);
                    relay_one.write(!rl.relay_one); /* Invert to Pull instead of release*/
                    rl.relay_one = !rl.relay_one;
                    lcd.locate(12, 0);
                    lcd.printf("(ON)");
                }
            } else if ((kp == '1') && (case1state1 == true)) {
                kp = 'z';
                case1state1 = false;
                lt.triggered = false;
                relay_one.write(0);//!rl.relay_one);
                rl.relay_one = !rl.relay_one;
                lcd.locate(11, 0);
                lcd.printf("(OFF)");
            }
            DisplayWrite(0, 1, "(2)RLY2     (  )", false); /* Rly2 on off */
            lcd.locate(13, 1);
            lcd.printf("%ds", rl.delay_val_s);
            if ((kp == '2') && (case1state2 == false)) {
                kp = 'z';
                case1state2 = true;
                relay_timer_countdown(false);
                relay_two.write(!rl.relay_two);
                lcd.locate(12, 1);
                lcd.printf("(ON)");
            } else if((kp == '2') && (case1state2 == true)) {
                case1state2 = false;
                relay_two.write(rl.relay_two);
                lcd.locate(11, 1);
                lcd.printf("(OFF)");
            }
            DisplayWrite(0, 3, "<0> to Return", false);
            break;
        case 2:
            DisplayWrite(0, 0, "A)LT ON/OFF(   )", true);
            DisplayWrite(0, 1, "B)Trg LVL(    V)", false);
            lcd.locate(10, 1);
            lcd.printf("%.1f", lt.trigger_level_v);
            if (kp == 'A') {
                kp = 'z';
                lt.on_off = !lt.on_off;
            }
            if (lt.on_off == true) {
                DisplayWrite(0, 0, "A)LT ON/OFF (ON)", false);
                zc.set = false;
            } else {
                DisplayWrite(0, 0, "A)LT ON/OFF(OFF)", false);
            }
            if (kp == 'B') {
                kp = 'z';
                DisplayWrite(0, 3,"B) to Confirm", false);
                while (kp != 'B') {
                    update_dc_level();//dc_level());
                }
            }
            DisplayWrite(0, 3, "<0> To Return   ", false);
            break;
        case 3:
            DisplayWrite(4, 0, "Contrast", true);
            DisplayWrite(0, 1, "<1            3>", false);
            contrast_set();
            DisplayWrite(0, 3, "<0> To Return   ", false);
            break;
    }
}

void dc_level_run()
{
    if((current_dc_level()) > (lt.trigger_level_v)) {
        relay_one.write(1);//!rl.relay_one);
        lcd.locate(12, 0);
        lcd.printf("(ON)");
        lt.triggered = true;
    }
}

float current_dc_level() /*Read from A1*/
{
    float read_voltage = A1Pin.read();
    float return_voltage = (read_voltage * 10); /* Supply voltage = 3V3 */
    printf("Return voltage %.1f", return_voltage);
    return return_voltage;
}

void int_on_off()
{
    if (zc.on_off == true) {
        // zc.on_off = false; /*test */
        event_one.rise(&ISR_zero_cross); /* enable interrupt */
    } else {
        event_one.rise(NULL); /* disable interrupt */
    }
}

void ISR_zero_cross()
{
    event_one.rise(NULL);
    wait_us(zc.timer_val_us);
    relay_one.write(!rl.relay_one);//!rl.relay_one);// inverter dette for at få den til at slippe relæet i stedet for at trække
//   relay_two.write(!rl.relay_two);//!rl.relay_two);
//   zc.on_off = false;
}

void update_dc_level()//float dc_level)
{
    lcd.setCursor(TextLCD_I2C::CurOn_BlkOn);
    lt.trigger_level_v = select_dc_level();
    static unsigned long previous_millis = 0;
    unsigned long current_millis = timer.read_ms();
    const int interval = 150;
    if ((current_millis - previous_millis) >= interval) {
        previous_millis = current_millis;
        lcd.locate(10, 1);
        lcd.printf("    ");
        lcd.locate(10, 1);
        lcd.printf("%.1f", lt.trigger_level_v);
    }
    lcd.setCursor(TextLCD_I2C::CurOff_BlkOff);
}

float select_dc_level() /*Read from PM*/
{
    float read_voltage = pm.read();
    float return_voltage = (read_voltage * 10); /* Supply voltage = 3V3 */
    return return_voltage;
}

void relay_timer_countdown(bool rl1_rl2)
{
    if (rl1_rl2 == true) { /* RL1 */
        for (short x = rl.delay_val_s; x >= 0; x--) {
            wait_ms(1000);
            lcd.locate(13, 0);
            lcd.printf("   ");
            lcd.locate(13, 0);
            lcd.printf("%ds)", x);
        }
    } else if (rl1_rl2 == false) { /* RL2 */
        for (short z = rl.delay_val_s; z >= 0; z--) {
            wait_ms(1000);
            lcd.locate(13, 1);
            lcd.printf("   ");
            lcd.locate(13, 1);
            lcd.printf("%ds)", z);
        }
    }
}

void delay_s()
{
    rl.pm_read = pm.read();
    static unsigned long previous_millis = 0;
    unsigned long current_millis = timer.read_ms();
    const int interval = 150;
    if ((current_millis - previous_millis) >= interval) {
        previous_millis = current_millis;
        rl.delay_val_s = (rl.pm_read * 9);
        rl.delay_val_ms = (rl.delay_val_s * 1000);
    }
}

float relay_timer()
{
    float return_time_ms = (zc.pm_read * 20);
    zc.timer_val_us = (return_time_ms * 1000);
//    printf("timer_val_us: %d\r", zc.timer_val_us);
    return return_time_ms;
}

void update_timer(float relay_timer_ms)
{
    lcd.setCursor(TextLCD_I2C::CurOn_BlkOn);
    zc.pm_read = pm.read();
    static unsigned long previous_millis = 0;
    unsigned long current_millis = timer.read_ms();
    const int interval = 150;
    if ((current_millis - previous_millis) >= interval) {
        previous_millis = current_millis;
        lcd.locate(9, 0);
        lcd.printf("    ");
        lcd.locate(9, 0);
        lcd.printf("%.1f", relay_timer_ms);
    }
    lcd.setCursor(TextLCD_I2C::CurOff_BlkOff);
}

void DisplayWrite(short LinjeNr, short CursorPlacering, const char * TextToPrint, bool ClearDisplay)
{
    if (ClearDisplay == true) {
        lcd.cls();
    }
    lcd.locate(LinjeNr, CursorPlacering);
    lcd.printf(TextToPrint);
}

void structsinit()
{
    zc.set = true;
    zc.on_off = false;
    zc.freq = false;
    rl.relay_one = false;
    rl.relay_two = false;
    rl.delay_val_s = 0;
    lt.on_off = false;
    lt.trigger_level_v = 0.0;
    lt.triggered = false;
}

void contrast_set()
{
    if ((kp == '3') && (contrast_val < 10)) {
        contrast_val++;
    } else if((kp == '1') && (contrast_val > 0)) {
        contrast_val--;
    }

    lcd.locate(3, 1);
    for (int x = 0; x < contrast_val; x++) {
        lcd.printf("#");

    }
    //contrast = contrast_val / 10;
}
