/******************************************************************//**
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "max14661.h"


//*********************************************************************
Max14661::Max14661(PinName sda, PinName scl, max14661_i2c_adrs_t i2c_adrs)
:_i2c(new I2C(sda, scl)), _i2c_owner(true), _w_adrs(i2c_adrs << 1), _r_adrs((i2c_adrs << 1) | 1)
{

}


//*********************************************************************
Max14661::Max14661(I2C & i2c_bus, max14661_i2c_adrs_t i2c_adrs)
:_i2c(&i2c_bus), _i2c_owner(false), _w_adrs(i2c_adrs << 1), _r_adrs((i2c_adrs << 1) | 1)
{
}


//*********************************************************************
Max14661::~Max14661()
{
    if(_i2c_owner)
    {
        delete _i2c;
    }
}


//*********************************************************************
uint16_t Max14661::wrt_cmd_registers(max14661_cmds_t cmdA, 
                              max14661_cmds_t cmdB)
{
    uint8_t data[3];
    uint8_t data_length = 0;
    uint16_t rtn_val = 1;
    
    //build packet
    data[data_length++] = CMD_A;
    data[data_length++] = cmdA;
    data[data_length++] = cmdB;
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, data_length);
    
    return(rtn_val);
}


//*********************************************************************
uint16_t Max14661::wrt_shadow_registers(uint16_t bankA, uint16_t bankB)
{
    uint8_t data[5];
    uint8_t data_length = 0;
    uint16_t rtn_val = 1;
    
    data[data_length++] = SHDW0;
    data[data_length++] = (bankA & 0x00FF);
    data[data_length++] = ((bankA >> 8) & 0x00FF);
    data[data_length++] = (bankB & 0x00FF);
    data[data_length++] = ((bankB >> 8) & 0x00FF);
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, data_length);
    
    return(rtn_val);
}


//*********************************************************************
uint16_t Max14661::wrt_dir_registers(uint16_t bankA, uint16_t bankB)
{
    uint8_t data[5];
    uint8_t data_length = 0;
    uint16_t rtn_val = 1;
    
    data[data_length++] = DIR0;
    data[data_length++] = (bankA & 0x00FF);
    data[data_length++] = ((bankA >> 8) & 0x00FF);
    data[data_length++] = (bankB & 0x00FF);
    data[data_length++] = ((bankB >> 8) & 0x00FF);
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, data_length);
    
    return(rtn_val);
}


//*********************************************************************
uint16_t Max14661::set_switches(uint16_t bankA, uint16_t bankB)
{
    uint8_t data[7];
    uint8_t data_length = 0;
    uint16_t rtn_val = 1;
    
    data[data_length++] = SHDW0;
    data[data_length++] = (bankA & 0x00FF);
    data[data_length++] = ((bankA >> 8) & 0x00FF);
    data[data_length++] = (bankB & 0x00FF);
    data[data_length++] = ((bankB >> 8) & 0x00FF);
    data[data_length++] = COPY_SHADOW;
    data[data_length++] = COPY_SHADOW;
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, data_length);
    
    return(rtn_val);
}


//*********************************************************************
uint16_t Max14661::rd_dir_registers(uint8_t* data)
{
    uint16_t rtn_val = 1;
    
    data[0] = DIR0;
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, 1);
    
    if(!rtn_val)
    {
        rtn_val = _i2c->read(_r_adrs,(char*) data, 4);
    }
    
    return(rtn_val);
}


//*********************************************************************  
uint16_t Max14661::rd_shadow_registers(uint8_t* data)  
{
    uint16_t rtn_val = 1;
    
    data[0] = SHDW0;
    
    rtn_val = _i2c->write(_w_adrs,(const char*) data, 1);
    
    if(!rtn_val)
    {
        rtn_val = _i2c->read(_r_adrs,(char*) data, 4);
    }
    
    return(rtn_val);
}
