/******************************************************************//**
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "ard2pmod.h"


//*********************************************************************
Ard2Pmod::Ard2Pmod(PmodType pmod_type, PinName ow_pin): 
_mux(D14, D15, Max14661::MAX14661_I2C_ADRS0)
{
    switch(pmod_type)
    {
        case PMOD_TYPE_I2C_A:
            _mux.set_switches((Max14661::SW12 | Max14661::SW09), (Max14661::SW11 | Max14661::SW10));
        break;
            
        case PMOD_TYPE_I2C_B:
            _mux.set_switches((Max14661::SW09 | Max14661::SW07), (Max14661::SW10 | Max14661::SW08));
        break;
            
        case PMOD_TYPE_I2C_AB:
            _mux.set_switches((Max14661::SW12 | Max14661::SW09 | Max14661::SW07), (Max14661::SW11 | Max14661::SW10 | Max14661::SW08));
        break;
            
        case PMOD_TYPE_1_GPIO:
            _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
        break;
            
        case PMOD_TYPE_2_SPI:
            _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
        break;
            
        case PMOD_TYPE_3_UART:
            _mux.set_switches((Max14661::SW12 | Max14661::SW01), (Max14661::SW11 | Max14661::SW02));
        break;
            
        case PMOD_TYPE_4_UART:
            _mux.set_switches((Max14661::SW13 | Max14661::SW02), (Max14661::SW12 | Max14661::SW01));
            break;
            
        case PMOD_TYPE_5_HBRIDGE:
            _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
        break;
            
        case PMOD_TYPE_6_HBRIDGE:
            _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
        break;
            
        case PMOD_TYPE_7_ONEWIRE_A:
        
            //set switches for owm_A
            switch(ow_pin)
            {
                case D0:
                    _mux.set_switches((Max14661::SW01 | Max14661::SW11), 0);
                break;
                
                case D1:
                    _mux.set_switches((Max14661::SW02 | Max14661::SW11), 0);
                break;
                
                case D2:
                    _mux.set_switches((Max14661::SW03 | Max14661::SW11), 0);
                break;
                
                case D3:
                    _mux.set_switches((Max14661::SW04 | Max14661::SW11), 0);
                break;
                
                case D4:
                    _mux.set_switches((Max14661::SW05 | Max14661::SW11), 0);
                break;
                
                case D5:
                    _mux.set_switches((Max14661::SW06 | Max14661::SW11), 0);
                break;
                
                case D6:
                    _mux.set_switches((Max14661::SW07 | Max14661::SW11), 0);
                break;
                
                case D7:
                    _mux.set_switches((Max14661::SW08 | Max14661::SW11), 0);
                break;
                
                case D8:
                    _mux.set_switches((Max14661::SW16 | Max14661::SW11), 0);
                break;
                
                case D9:
                    _mux.set_switches((Max14661::SW15 | Max14661::SW11), 0);
                break;
                
                case D10:
                    _mux.set_switches((Max14661::SW14 | Max14661::SW11), 0);
                break;
                
                case D11:
                    _mux.set_switches((Max14661::SW13 | Max14661::SW11), 0);
                break;
                
                case D12:
                    _mux.set_switches((Max14661::SW12 | Max14661::SW11), 0);
                break;
                
                default:
                    _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
                break;
            }  
            
        break;
            
        case PMOD_TYPE_8_ONEWIRE_B:
            
            //set switches for owm_B
            switch(ow_pin)
            {
                case D0:
                    _mux.set_switches(0, (Max14661::SW01 | Max14661::SW08));
                break;
                
                case D1:
                    _mux.set_switches(0, (Max14661::SW02 | Max14661::SW08));
                break;
                
                case D2:
                    _mux.set_switches(0, (Max14661::SW03 | Max14661::SW08));
                break;
                
                case D3:
                    _mux.set_switches(0, (Max14661::SW04 | Max14661::SW08));
                break;
                
                case D4:
                    _mux.set_switches(0, (Max14661::SW05 | Max14661::SW08));
                break;
                
                case D5:
                    _mux.set_switches(0, (Max14661::SW06 | Max14661::SW08));
                break;
                
                case D6:
                    _mux.set_switches(0, (Max14661::SW07 | Max14661::SW08));
                break;
                
                case D7:
                    _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
                break;
                
                case D8:
                    _mux.set_switches(0, (Max14661::SW16 | Max14661::SW08));
                break;
                
                case D9:
                    _mux.set_switches(0, (Max14661::SW15 | Max14661::SW08));
                break;
                
                case D10:
                    _mux.set_switches(0, (Max14661::SW14 | Max14661::SW08));
                break;
                
                case D11:
                    _mux.set_switches(0, (Max14661::SW13 | Max14661::SW08));
                break;
                
                case D12:
                    _mux.set_switches(0, (Max14661::SW12 | Max14661::SW08));
                break;
                
                case D13:
                    _mux.set_switches(0, (Max14661::SW11 | Max14661::SW08));
                break;
                
                default:
                    _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
                break;
            } 
            
        break;
            
        default:
            _mux.wrt_cmd_registers(Max14661::DISABLE_BANK, Max14661::DISABLE_BANK);
        break;
    } 
}


