/* mbed Terminal Library, for ANSI/VT200 Terminals and ecape codes
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "Terminal.h"

Terminal::Terminal(PinName tx, PinName rx) : Serial(tx, rx){}

void Terminal::cls() {
    this->printf("\033[2J");
}

void Terminal::home(){
    this->printf("\033[H");
}

void Terminal::locate(int column, int row) {
    // Cursor Home    <ESC>[{ROW};{COLUMN}H
    this->printf("\033[%d;%dH%c", row + 1, column + 1);
}

static int rgb888tobgr111(int colour) {
    int r = (colour >> 23) & 1;
    int g = (colour >> 15) & 1;
    int b = (colour >> 7) & 1;
    return (b << 2) | (g << 1) | (r << 0);
}

void Terminal::foreground(int colour) {
    // Set Attribute Mode    <ESC>[{n}m
    // Foreground Colours : 30 + bgr
    int c = 30 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

void Terminal::background(int colour) {
    // Set Attribute Mode    <ESC>[{n}m
    // Background Colours : 40 + bgr
    int c = 40 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

int32_t Terminal::get_int32(const char *msg, const int32_t min_val, const int32_t max_val)
{
    int32_t user_input;
    //mbed uses C++ 2003 so no benifit in using C++ string for this fx
    char str[12];
    uint8_t idx = 0;
    
    do
    {
        //print prompt
        this->printf(msg);
        
        //get user input
        idx = 0;
        do
        {
            //wait for first char
            do
            {
                if(this->readable())
                {
                    str[idx++] = this->getc();
                }
            }
            while(idx == 0);
        }
        while((str[idx - 1] != 0x0A) && (str[idx - 1] != 0x0D) && (idx < 12));
        
        //wait for possible additional char on windows machines
        //at even the slowest of baudrates, hopefully.
        //need a better way...
        wait_ms(50);
        
        //gobble up trailing LF if there
        while(this->readable())
        {
            this->getc();
        }
        
        //replace CR or LF with \0
        str[idx - 1] = '\0';
        //convert str into int
        user_input = atoi(str);
        
        if((user_input < min_val) || (user_input > max_val))
        {
            this->printf("\r\nYou entered = %d\r\n", user_input);
            this->printf("\r\nOut of range\r\n");
        }
    }
    while((user_input < min_val) || (user_input > max_val));
    
    return(user_input);
}
    
char Terminal::get_char(const char *msg, const char min_val, const char max_val)
{
    //mbed uses C++ 2003 so no benifit in using C++ string for this fx
    char c[3];
    uint8_t idx = 0;
    
    do
    {
        this->printf(msg);
        
        //get user input
        idx = 0;
        do
        {
            //wait for first char
            do
            {
                if(this->readable())
                {
                    c[idx++] = this->getc();
                }
            }
            while(idx == 0);
        }
        while((c[idx-1] != 0x0A) && (c[idx-1] != 0x0D)  && (idx < 3));
        
        //wait for possible additional char on windows machines
        //at even the slowest of baudrates, hopefully.
        //need a better way...
        wait_ms(50);
        
        //gobble up trailing LF if there
        while(this->readable())
        {
            this->getc();
        }
        
        //replace CR or LF with \0
        c[idx - 1] = '\0';
        
        
        if((c[0] < min_val) || (c[0] > max_val))
        {
            this->printf("\nYou entered = %c\n", c[0]);
            this->printf("\nOut of range\n");
        }
    }
    while((c[0] < min_val) || (c[0] > max_val));
    
    return c[0];
}


float Terminal::get_float(const char *msg, const float min_val, const float max_val)
{
    float user_input;
    //mbed uses C++ 2003 so no benifit in using C++ string for this fx
    char str[12];
    uint8_t idx = 0;
    
    do
    {
        printf(msg);
        
        //get user input
        idx = 0;
        do
        {
            //wait for first char
            do
            {
                if(this->readable())
                {
                    str[idx++] = this->getc();
                }
            }
            while(idx == 0);
        }
        while((str[idx-1] != 0x0A) && (str[idx-1] != 0x0D)  && (idx < 32));
        
        //wait for possible additional char on windows machines
        //at even the slowest of baudrates.
        //Need a better way...
        wait_ms(50);
        
        //gobble up trailing LF if there
        while(this->readable())
        {
            this->getc();
        }
        
        //replace CR or LF with \0
        str[idx - 1] = '\0';
        //convert to float
        user_input = atof(str);
        
        if((user_input <= min_val) || (user_input >= max_val))
        {
            printf("\nYou entered = %f\n", user_input);
            printf("\nOut of range\n");
        }
    }
    while((user_input <= min_val) || (user_input >= max_val));
    
    return(user_input);
}
