/**********************************************************************
* Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
******************************************************************************/


#include "mbed.h"


PinName STATUS_RED   = P1_2;
PinName STATUS_GREEN = P1_3;
PinName STATUS_BLUE  = P1_4;
PinName BOOST_EN     = P2_2;


int main()
{
    //Enable 5V rail first, active high
    DigitalOut boostEN(BOOST_EN, 1);
    
    //Instantiate led objects, active high via bjt pulldown
    DigitalOut rLED(STATUS_RED, 0);
    DigitalOut gLED(STATUS_GREEN, 0);
    DigitalOut bLED(STATUS_BLUE, 0);
    
    //Simple array to rotate through
    DigitalOut leds[] = {rLED, gLED, bLED};
    
    I2C i2c_bus(I2C1_SDA, I2C1_SCL);
    
    uint32_t count = 0;
    
    while(1)
    {
        leds[count % 3] = 1;
        wait(0.25);
        leds[count % 3] = 0;
        wait(0.25);
        
        count++;
        
        printf("Count = %d\r\n", count);
    }
}