/*******************************************************************************
* The MIT License (MIT)
*
* Copyright (c) 2016 j3
*
* Permission is hereby granted, free of charge, to any person obtaining a copy 
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights 
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
* copies of the Software, and to permit persons to whom the Software is 
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in 
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
* SOFTWARE.
******************************************************************************/

#ifndef SHARP_LS012B7DD01_H
#define SHARP_LS012B7DD01_H

#include "mbed.h"

/**
* @brief Sharp LS012B&DD01 TFT-LCD 
*/
class SharpLS012B7DD01
{
	public:
	
	static const uint8_t DATA_UPDATE_MODE = 0x80;
	static const uint8_t DISPLAY_MODE = 0;
	static const uint8_t ALL_CLEAR_MODE = 0x20;
	
	enum SharpCmdResult
	{
		Success,
		Failure,
	};
	
	/**
	* @brief SharpLS012B7DD01 Constructor
	*/
	SharpLS012B7DD01(PinName disp, PinName extcomin, PinName cs, SPI &spiBus);
	
	/**
	* @brief SharpLS012B7DD01 Destructor
	*/
	~SharpLS012B7DD01();
	
	/**
	* @brief Prints character to given line and position
	*/
	SharpCmdResult print_char(uint8_t ln, uint8_t pos, char c);
	
	/**
	* @breif Prints string to given line and position
	*/
	SharpCmdResult print_str(uint8_t ln, uint8_t pos, const char *s);
	
	void clear_display();
	
	private:
	
	/**
	* @brief Writes memory of Sharp LS012B7DD01
	*/
	SharpCmdResult write_memory(uint8_t data[][23], uint8_t lines, uint8_t offset);
	
	/**
	* @brief Updates display
	*/
	void update(const uint8_t mode);
    
	/**
	* @brief Reverses bit order
	*/
	uint8_t rev_bit(uint8_t data);
	
	/**
	* @brief Call back for ticker
	*/
	void toggle_extcomin();
	
	uint8_t m_data[38][23];
	
	DigitalOut m_disp;
	DigitalOut m_extcomin;
	DigitalOut m_cs;
	SPI m_spi;
	Ticker m_extcominTicker;
};

#endif /*SHARP_LS012B7DD01_H*/