/******************************************************************************
* MIT License
*
* Copyright (c) 2017 Justin J. Jordan
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
******************************************************************************/


//https://developer.mbed.org/users/borislav/notebook/serial-port-plotter/


#include "mbed.h"

int32_t float_to_int(float f);


int main()
{
    DigitalOut rLed(LED_RED, 1);
    DigitalOut gLed(LED_GREEN, 1);
    DigitalOut bLed(LED_BLUE, 1);

    DigitalOut leds[] = {rLed, gLed, bLed};
    
    Serial debug(USBTX, USBRX);
    debug.baud(115200);
    
    //const float PI = 3.14159265F;
    float angle[] = {0.0F, 120.0F, 240.0F};
    float sinScaled;
    int32_t data[3];
    uint32_t cnt = 0;
    
    while(1)
    {
        //get data
        for(uint32_t idx = 0; idx < 3; idx++)
        {
            /*If you have Qt creator installed, you can open the SerialPlotter 
              project and edit line 440 of mainwindow.cpp too the following
              
              //else if(isdigit(temp[i]) || isspace(temp[i]) || temp[i] == '-')
              
              without the comment, of course.
              
              If you dont, use the commented out version of sinScaled below and 
              comment the first one out.
              */
              
            //get sin, scaled up
            sinScaled = (100.0F * sin(angle[idx]*(PI/180.0F)));
            
            //sinScaled = (100 + (100.0F * sin(angle[idx]*(PI/180.0F))));
            
            data[idx] = float_to_int(sinScaled);
            
            //inc angle, check for roll over
            angle[idx] += 1.0F;
            if(angle[idx] > 360.0F)
            {
                angle[idx] = 0.0F;
            }
        }
        
        //plot
        debug.printf("$%d %d %d;", data[0], data[1], data[2]);
        
        //blink some lights, just cause you have to
        leds[cnt % 3] = !leds[cnt % 3];
        cnt++;
        
        //wait a bit
        wait(0.01F);
    }
}


int32_t float_to_int(float f)
{
    int32_t i;
    
    if (f >= 0.0F)
    {
        i = static_cast<int32_t>(f + 0.5F); 
    } 
    else 
    {
        i = static_cast<int32_t>(f - 0.5F);
    }
    
    return i;
}