/******************************************************************************
* MIT License
*
* Copyright (c) 2017 Justin J. Jordan
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
******************************************************************************/


//Demo uses pot connected between 3.3 and GND with wiper on AIN_0.
//SQWV is generated on P4_0


#include "mbed.h"
#include "max32630fthr.h"
#include "adc.h"


int main()
{
    MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
    
    MBED_ASSERT(ADC_Init() == E_NO_ERROR);
    
    //Init pwm signal
    PwmOut pwmOut(P4_0);
    pwmOut.write(0.5F);
    
    uint16_t rawADCdata;
    float volts = 0.0F;
    float period = 0.0F;
    
    pwmOut.period(period);
    
    printf("\033[H");  //home
    printf("\033[0J"); //erase from cursor to end of screen
    
    //loop
    while(1)
    {   
        //Do ADC conversion
        ADC_StartConvert(ADC_CH_0_DIV_5, 1, 1);
        ADC_GetData(&rawADCdata);
        
        //Get ADC value in volts
        volts = ((6.0F * rawADCdata) / 1023.0F);
        
        //convert to period in seconds for pwm
        period = (1.0F / ((300.0F * volts) + 10.0F));
        
        //Update sqwv period
        pwmOut.period(period);
        pwmOut.write(0.5F);
        
        //Display data
        printf("Raw Data = 0x%04x\r\n", rawADCdata);
        printf("Volts    = %3.2f\r\n", volts);
        printf("Period   = %5.4f\r\n", period);
        printf("\033[H");  //home
        
        wait(0.1F);
    }
}