/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */


#include "mbed.h"
#include "max32630fthr.h"
#include "MultipinRGB.h"


MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);


int main ()
{
    MultipinRGB leds(LED1, LED2, LED3);
    float redDutyCycle(0.5F), grnDutyCycle(0.0F), bluDutyCycle(0.0F), temp;

    while(1) 
    {
        leds.writeLeds(redDutyCycle, grnDutyCycle, bluDutyCycle);
        
        printf("RGB Duty Cycles = %3.1f, %3.1f, %3.1f\r\n",
               redDutyCycle, grnDutyCycle, bluDutyCycle);
               
        //shift r->g->b->r
        temp = bluDutyCycle;
        bluDutyCycle = grnDutyCycle;
        grnDutyCycle = redDutyCycle;
        redDutyCycle = temp;
        
        wait(0.25);
    }
}