

#include "mbed.h"
#include "max32630fthr.h"

const uint32_t BLINK_DELAY = 250;

void blink_led(DigitalOut &led, const uint32_t delay);

int main()
{
    MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
    
    DigitalOut rLed(LED_RED, 1);
    DigitalOut gLed(LED_GREEN, 1);
    DigitalOut bLed(LED_BLUE, 1);
    
    DigitalOut led_array[] = {rLed, gLed, bLed};
    
    while(1)
    {
        for(int8_t idx = 2; idx >= 0; idx--)
        {
            blink_led(led_array[idx], BLINK_DELAY);
        }
    }
}

void blink_led(DigitalOut &led, const uint32_t delay)
{
    led = !led;
    wait_ms(delay);
    led = !led;
}
