/******************************************************************************
* MIT License
*
* Copyright (c) 2017 Justin J. Jordan
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:

* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.

* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
******************************************************************************/


#include "mbed.h"
#include "max32630fthr.h"


int main ()
{
    //Init board and set GPIO to 3.3V logic
    MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
    
    //Turn RGB LED off
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    AnalogIn a0(AIN_0);
    float a0_val;
    
    while(1)
    {
        //ADC is configured for no input scaling, no input buffer bypass,
        //and internal ref of 1.2V
        //Default range is 0 to 1.2V.  
        //See target 'analogin_api.c' for mbed-2.0 and mbed-os. 
        //Target User's guide page 567 covers ADC 
        //https://www.maximintegrated.com/en/app-notes/index.mvp/id/6349
        a0_val = (a0.read() * 1.2F);
        
        printf("AIN_0 = %f volts\r\n", a0_val);
        
        wait(0.25);
        gLED = !gLED;
    }
}