#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "sensirion_sf04.h"

// Gas flow sensor defines
#define MAINFLOW_ADDR 0x40
// End gas flow sensor defines

Serial pc(USBTX, USBRX, 100000); // tx, rx, baud

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl, int freq) : I2C(sda, scl) {
        frequency(freq);
    };
};

//I2CPreInit gI2C1(I2C_SDA, I2C_SCL, I2C frequency);
I2CPreInit i2c3(PB_4, PA_8, 100000);


// Sensirion gas flow sensor object (i2c object, i2c address, calibration field, resolution 9-16 bit)
SF04 mainflow(i2c3, MAINFLOW_ADDR, 0, 16); // Gas flow sensor (SFM7033)

#endif