#include "mbed.h"
#include "rtos.h"
#include "coil-driver.h"

Coil yellow(A0, 300, 40, 4); // Injector
InterruptIn dutycycleup(A2);
InterruptIn dutycycledown(D4);
InterruptIn frequencyup(A5);
InterruptIn frequencydown(A4);

Serial pc(USBTX, USBRX);

double frequency=5;
double dutycycle=0.75;
float openvalue=(((1/frequency)*dutycycle));
float offvalue=(1/frequency)-openvalue;

void dutycycleincrease()
{
    dutycycle=dutycycle+0.01;
}

void dutycycledecrease()
{
    dutycycle=dutycycle-0.01;
}

void frequencyincrease()
{
    frequency=frequency+1;
}
void frequencydecrease()
{
    frequency=frequency-1;
}

int main() {
 
dutycycleup.rise(&dutycycleincrease);
dutycycledown.rise(&dutycycledecrease);
frequencyup.rise(&frequencyincrease);
frequencydown.rise(&frequencydecrease);     
  
while(1){
    
float openvalue=(((1/frequency)*dutycycle));
float offvalue=(1/frequency)-openvalue;
    
yellow.on();
wait(openvalue);
yellow.off();
wait(offvalue);

pc.printf("Frequency: %f\r\n", frequency);
pc.printf("\n");
pc.printf("Duty Cycle: %f\r\n", dutycycle);
}
}