// Begin sample code
/*
#include "mbed.h"
#include "rtos.h"
#include "coil-driver.h"
// Coil parameters [control pin, spike time (us), hold time period (us), hold time pulse width (us)]
Coil orange(A0, 500, 40, 3); // Valve driven by pin A0, 500us spike time, 25kHz PWM at 7.5% duty cycle

Coil yellow(A1, 5000, 40, 6); // Valve driven by pin A1, 5ms spike time, 25kHz PWM at 15% duty cycle

int main()
{
    while (true) {
        orange.on();
        yellow.on();
        Thread::wait(500);
        orange.off();
        yellow.off();
        Thread::wait(500);
    }
}
*/
// End sample code

#include "coil-driver.h"

// Default constructor
Coil::Coil(PinName _controlPin, uint16_t _spikeus, uint16_t _holdperiod_us, uint16_t _holdpulse_us)
    :   controlOut(_controlPin),
        spikeus(_spikeus),
        holdperiod_us(_holdperiod_us),
        holdpulse_us(_holdpulse_us)
{
    controlOut.write(0.0); // Ensure coil output is off by default
    controlOut.period_us(holdperiod_us); // PWM control period (uint16_t microseconds)

};

void Coil::on()
{
    controlOut.write(1.0);
    wait_us(spikeus);
    controlOut.pulsewidth_us(holdpulse_us);
}

void Coil::off()
{
    controlOut.write(0.0);
}