#include "mbed.h"
#include "rtos.h"
#include "coil-driver.h"

// Coil parameters [control pin, spike time (us), hold time period (us), hold time pulse width (us)]
Coil yellow(A0, 300, 40, 4); // Injector

Coil orange(A1, 2000, 40, 12); // Shutoff valve
DigitalOut fb(A2); // Fast shutoff circuit for shutoff valve. High when valve is off, low when valve is on.

InterruptIn injectorValveStatus(D7);
InterruptIn shutoffValveStatus (D8);

void injectorValveOn()
{
    yellow.on();
}
void injectorValveOff()
{
    yellow.off();
}
void shutoffValveOn()
{
    fb=0;
    orange.on();
}
void shutoffValveOff()
{
    orange.off();
    fb=1;
}
int main()
{
    while(1)  {
    shutoffValveOff();
    wait(1);
    shutoffValveOn();
    wait(1);    
        }
}
