#include "mbed.h"
#include <string>
#include <algorithm>
#include <vector>

using namespace std;
Serial pc(SERIAL_TX, SERIAL_RX);
vector<string> tokens;
char ch;
string str("1234 4567 91011");

double x;
double y;
double z;

void Tokenize(const string& str,vector<string>& tokens,const string& delimiters = " ")
{
    // Skip delimiters at beginning.
    string::size_type lastPos= str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos= str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos){
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

void callback(){
ch=pc.getc();
str+=ch;
return;
}

int main()
{
    pc.baud(115200);
    pc.attach(&callback);
    
    while(1){
    Tokenize(str, tokens);
    x=atof(tokens[0].c_str());
    y=atof(tokens[1].c_str());
    z=atof(tokens[2].c_str());
    str.clear();
    pc.printf("%0.2f\t %0.2f\r\n",x,y);
}
}