#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "keller_pressure.h"
#include "sensirion_sf04.h"
#include "PID.h"
#include "coil-driver.h"
#include "VL6180.h"
/*Start of Where Additional Code was Added
--------------------------------------------------------------------------------------------------*/
//Coil shutoff(A1, 5000, 40, 6); // Shutoff valve, 5ms spike time, 25kHz PWM at 15% duty cycle
Coil injector(A0, 200, 40, 3); // Injector valve, 200us spike time, 25kHz PWM at 7.5% duty cycle

InterruptIn dutycycleup(A2);
InterruptIn dutycycledown(D4);
InterruptIn frequencyup(A5);
InterruptIn frequencydown(A4);

Thread Injector_Valve_Control;

double frequency=5.00;
double dutycycle=0.75;
float openvalue=(((1/frequency)*dutycycle));
float offvalue=(1/frequency)-openvalue;

/*
--------------------------------------------------------------------------------------------------*/


// Mbed application shield display
#include "C12832A1Z.h"
#include "Small_7.h"
#include "Fonts/ArialR12x14.h"

C12832A1Z lcd(D11, D13, D12, D7, D10); // MOSI, SCK, Reset, A0, CS
// LCD width and height (minus 1)
#define lcdWidth 127
#define lcdHeight 31

// ISO/SEV pressure: 10psi, DES: 25-30psi
#define pumpSetPointPSI 45
#define pumpMinPSI 0
#define pumpMaxPSI 85
//#define pumpHystPSI 2

// Gas flow sensor defines
#define SFM7033_ADDR 0x40
#define SFM7034_ADDR 0x40
// End gas flow sensor defines

// Liquid pump defines
// PID settings
#define pumpPIDRate .2 // Pump PID computation interval (seconds)
float pumpKp = 4.0;
float pumpKi = 1.0;
#define pumpKd 0

#define pumpPwmFrequency 1000 // Frequency of PWM signal supplied to pump
#define pumpTachPoles 6 // 6 pulses per revolution
#define pumpTachPin PA_10 // Pump tach input (green wire)
#define pumpCtrlPin PB_13 // Pump control (white wire)
// End Liquid pump defines

Thread print_process_values_t, update_pressures_t, update_flow1_t, update_flow2_t, update_level_t, update_lcd_t, update_shutoff_t;
Mutex i2c1_m, i2c2_m, i2c3_m, stdio_m;

//DigitalOut myled(LED2);
Serial pc(SERIAL_TX, SERIAL_RX, 115200); // tx, rx, baud

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl, int freq) : I2C(sda, scl) {
        frequency(freq);
    };
};

//I2CPreInit gI2C1(I2C_SDA, I2C_SCL, I2C frequency);
I2CPreInit i2c1(PB_9, PB_8, 100000);
I2CPreInit i2c2(PB_3, PB_10, 100000);
I2CPreInit i2c3(PB_4, PA_8, 100000);

KELLER_PRESSURE pumpPressure(i2c1, 0x40);

// Sensirion gas flow sensor object (i2c object, i2c address, calibration field, resolution 9-16 bit)
// calibration field 1: Air, 2: O2, 3: N2O
SF04 mainflow(i2c2, SFM7033_ADDR, 0, 9); // Gas flow sensor (SFM7033)
SF04 loopflow(i2c3, SFM7034_ADDR, 0, 9);
// Mbed application shield
//AnalogIn pot1(A0);
AnalogIn pot2(A1);

PwmOut pump(pumpCtrlPin);

//pump.period(.001);

PID pump_control_PID(pumpKp, pumpKi, pumpKd, pumpPIDRate);

InterruptIn pumpTach(pumpTachPin);
int pumpTachCounts = 0;
float pumpRpm = 0;

//PwmOut ledRed(PE_11);
//PwmOut ledGrn(PD_15);
//DigitalOut ledBlu(PF_12);

// Level sensor
//VL6180 level(i2c1); //I2C object
//float agentlevel = 0;
Ticker pump_tach_ticker, pump_pid_ticker, print_process_values_ticker, lcd_update_ticker;
#endif