#include "coil-driver.h"

// Default constructor
Coil::Coil(PinName _controlPin, uint16_t _spikeus, uint16_t _holdperiod_us, uint16_t _holdpulse_us)
    :   controlOut(_controlPin),
        spikeus(_spikeus),
        holdperiod_us(_holdperiod_us),
        holdpulse_us(_holdpulse_us)
{
    controlOut.write(0.0); // Ensure coil output is off by default
    controlOut.period_us(holdperiod_us); // PWM control period (uint16_t microseconds)

};

char Coil::status()
{
    char status;
    if(controlOut.read() == 0) {
        status = 0;
    } else {
        status = 1;
    }
}

void Coil::on()
{
    if(controlOut.read() == 0.0) {
        controlOut.write(1.0);
        wait_us(spikeus);
        controlOut.pulsewidth_us(holdpulse_us);
    }
}

void Coil::off()
{
    controlOut.write(0.0);
}