#include "main.h"
//---------------------------

//-----------------------------
void pumpTachTrigger()
{
    
    pumpTachCounts++;
}

void pump_tach_update()
{
    float i = pumpTachCounts; // In case it triggers mid-calculation
    pumpTachCounts=0;
    pumpRpm = (i/pumpTachPoles)*60;
}

void pump_init()
{
    pump.period(.001); // 1kHz PWM
    pump = 0;
    
    
    //ledGrn.period(.001);

    
    

    pump_control_PID.setInputLimits(pumpMinPSI, pumpMaxPSI);
    pump_control_PID.setOutputLimits(0.0, 1.0); // Output is a PWM signal ranging from 0-1
    pump_control_PID.setMode(AUTO_MODE);
    pump_control_PID.setSetPoint(((double)pot2)*pumpMaxPSI); // pump setpoint based on pot 2*/
}

void pump_pid_update(char error)
{
    if (pumpPressure.status != 0x40) {
        pump = 0;
        pump_control_PID.reset();
    } else {
        pump_control_PID.setSetPoint(((double)pot2)*pumpMaxPSI);

        //Update the process variable.
        pump_control_PID.setProcessValue(pumpPressure.pressurePSI);
        //PID calculation and set the new output value.
        pump = pump_control_PID.compute();
        //pump = 0.1;
        //ledGrn = ((float)1.0-pump.read());
    }
}

void update_pressures()
{
    Timer timer;
    timer.start();
    char error;
    while (true) {
        i2c1_m.lock();
        timer.reset();
        error = pumpPressure.readPT();
        //error |= mixerPressure.readPT();
        int wait = (200 - timer.read_ms());
        i2c1_m.unlock();
        Thread::wait(wait);
        pump_pid_update(error);
    }
}

//------------------------------------------------   

void print_process_values()
{
    //Thread::wait(100); // Wait initially to allow sensors to update, prevents a zero reading from going to serial
    Timer timer;
    timer.start();
    while (true) {
        stdio_m.lock();
        timer.reset();

        pc.printf(" %.02f\t %.01f\t %.0f\r\n",
                   pumpPressure.pressurePSI, ((double)pot2-.002)*pumpMaxPSI, pumpRpm);
        int wait = (1000 - timer.read_ms());

        stdio_m.unlock();
        Thread::wait(wait);
    }
}

// main() runs in its own thread in the OS
int main()
{
    pump_init();
    pump_tach_update();
    //ledBlu = 1;
    pc.printf("Serenity Starting up...\n\r");
//--------------------------------------------

pumpTach.rise(&pumpTachTrigger); 
pump_tach_ticker.attach(&pump_tach_update, 1.0);  

//--------------------------------------------

    // Thread to poll pressure sensors
    update_pressures_t.set_priority(osPriorityNormal);
    update_pressures_t.start(update_pressures); 

    // Thread to poll flow sensor
    //update_flow1_t.set_priority(osPriorityNormal);
    //update_flow1_t.start(update_flow1);
    
    //Thread to poll flow sensor
    //update_flow2_t.set_priority(osPriorityNormal);
    //update_flow2_t.start(update_flow2);

    // Thread to send process values to serial port
    print_process_values_t.set_priority(osPriorityLow);
    print_process_values_t.start(&print_process_values);
    
    


         
        
    
}

