#include "main.h"
//---------------------------

EventQueue queue;

void dutycycleincrease(){
    dutycycle=dutycycle+0.01;
}

void dutycycledecrease(){
    dutycycle=dutycycle-0.01;
}

void frequencyincrease(){
    frequency=frequency+1;
}

void frequencydecrease(){
    frequency=frequency-1;
}

void injectorvalvecontrol(){
    while(true) {
        float openvalue=(((1/frequency)*dutycycle));
        float offvalue=(1/frequency)-openvalue;
        injector.on();
        wait(openvalue);
        injector.off();
        wait(offvalue);
    }
}

//-----------------------------
void pumpTachTrigger(){
    pumpTachCounts++;
}

void pump_tach_update(){
    float i = pumpTachCounts; // In case it triggers mid-calculation
    pumpTachCounts=0;
    pumpRpm = (i/pumpTachPoles)*60;
}

void pump_init(){
    pump.period(.001); // 1kHz PWM
    pump = 0;
    pump_control_PID.setInputLimits(pumpMinPSI, pumpMaxPSI);
    pump_control_PID.setOutputLimits(0.0, 1.0); // Output is a PWM signal ranging from 0-1
    pump_control_PID.setMode(AUTO_MODE);
    pump_control_PID.setSetPoint(((double)pot2)*pumpMaxPSI); // pump setpoint based on pot 2*/
}

void pump_pid_update(char error){
    if (pumpPressure.status != 0x40) {
        pump = 0;
        pump_control_PID.reset();
    } else {
        pump_control_PID.setSetPoint(((double)pot2)*pumpMaxPSI);

        //Update the process variable.
        pump_control_PID.setProcessValue(pumpPressure.pressurePSI);
        //PID calculation and set the new output value.
        pump = pump_control_PID.compute();
    }
}

void update_pressures(){
    Timer timer;
    timer.start();
    char error;
    while (true) {
        i2c1_m.lock();
        timer.reset();
        error = pumpPressure.readPT();
        //error |= mixerPressure.readPT();
        int wait = (200 - timer.read_ms());
        i2c1_m.unlock();
        Thread::wait(wait);
        pump_pid_update(error);
    }
}

void print_process_values()
{
    Thread::wait(100); // Wait initially to allow sensors to update, prevents a zero reading from going to serial
    Timer timer;
    timer.start();
    while (true) {
        stdio_m.lock();
        timer.reset();
        pc.printf(" %.02f\t %.01f\t %.0f\t %.02f\t %i\t %.02f\r\n",
                  pumpPressure.pressurePSI, ((double)pot2-.002)*pumpMaxPSI, pumpRpm,
                  frequency, x, dutycycle);//, agentlevel;
        int wait = (100 - timer.read_ms());
        stdio_m.unlock();
        Thread::wait(wait);
    }
}


void dutycycleint()
{
stdio_m.lock();
pc.printf("Hello");
x=x+1;
stdio_m.unlock();
    return;
    }

// main() runs in its own thread in the OS
int main()
{
    pump_init();
    pump_tach_update();
    dutycycleup.rise(&dutycycleincrease);
    dutycycledown.rise(&dutycycledecrease);
    frequencyup.rise(&frequencyincrease);
    frequencydown.rise(&frequencydecrease);
    pumpTach.rise(&pumpTachTrigger);
    pump_tach_ticker.attach(&pump_tach_update, 1.0);
    
    //Interrupt for Duty Cycle
    Thread eventThread;
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    pc.attach(&dutycycleint);

    //Thread to execute injector valve control
    Injector_Valve_Control.set_priority(osPriorityHigh);
    Injector_Valve_Control.start(injectorvalvecontrol);

    // Thread to poll pressure sensors
    update_pressures_t.set_priority(osPriorityNormal);
    update_pressures_t.start(update_pressures);

    // Thread to send process values to serial port
   // print_process_values_t.set_priority(osPriorityLow);
    //print_process_values_t.start(&print_process_values);
    
    while(1){}
}


