#include "main.h"

//Liquid Flow Sensor Adjacent to the Pump
void update_flow2()
{
    Timer timer;
    timer.start();
    char error;
    while (true) {
        i2c1_m.lock();
        timer.reset();
        error = mainflow.Measure(FLOW);
        //int wait = (200 - timer.read_ms());
        i2c1_m.unlock();
        //Thread::wait(wait);
    }
}

//High Speed Pressure Sensor  
void highspeedpressure(){
     while(true) {
        High_Speed_Pressure = analog_value.read(); // 
        High_Speed_Pressure = High_Speed_Pressure*100*(14.69/8.6); // Calibrate value to 1atm
        wait_ms(1);
  }  
}
void print_process_values()
{
    //Thread::wait(100); // Wait initially to allow sensors to update, prevents a zero reading from going to serial
    Timer timer;
    timer.start();
    while (true) {
        stdio_m.lock();
        timer.reset();

        pc.printf("%0.02fpsi raw: %u %.02f\r\n",
                High_Speed_Pressure, mainflow.flow.u16, t);
        //pc.printf("%.0f %s (raw: %i) Temp: %.1fC Vdd: %.2f\n\r", ((float)mainflow.flow.i16 / mainflow.scaleFactor.u16), mainflow.flowUnitStr, mainflow.flow.i16, (float)mainflow.temperature.i16/10, (float)mainflow.vdd.u16/1000);
        //int wait = 1;//(1000- timer.read_ms());
        stdio_m.unlock();
        //Thread::wait(wait);
    }
}

// main() runs in its own thread in the OS
int main()
{
    t1.start();
    //ledBlu = 1;
    pc.printf("Serenity Starting up...\n\r");
  
    //Thread to poll high speed pressure sensor
    HighSpeedPressure.set_priority(osPriorityNormal);
    HighSpeedPressure.start(highspeedpressure);
  
    //Thread to poll flow sensor
    update_flow2_t.set_priority(osPriorityNormal);
    update_flow2_t.start(update_flow2);

    // Thread to send process values to serial port
    print_process_values_t.set_priority(osPriorityLow);
    print_process_values_t.start(&print_process_values);

    while (true) {
        t= t1.read_ms();
             
    }
}

