/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Bluetooth_Terminal
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     : 18-12-2019, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto utiliza la Terminal Serial para interactuar con la 
**         Conexión Serial del Bluetooth como Terminal Serial
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**         First Release
**
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:                       I N C L U D E S
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
//#include "AnalogIn.h"
//#include "Led_RGB.h"
//#include <stdio.h>

/*
:...............................................................................
:                       D E F I N I C I O N E S
:...............................................................................
*/
#define LED_ON          0           // Estado para el Led Encendido
#define LED_OFF         1           // Estado para el Led Apagado
#define BUZZ_ON         1           // Estado para Buzzer Encendido
#define BUZZ_OFF        0           // Estado para Buzzer Apagado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define LOW             0           // Estado para Nivel "Bajo"
#define HIGH            1           // Estado para Nivel "Alto"
#define ON              0           // Estado para boton presionado
#define OFF             1           // Estado para boton sin presionar
#define HOLD            2           // Estado para boton mantenido
#define RELEASE         3           // Estado para boton liberado
#define TICKER_RATE     1000        // Periodo de Interrupción (us)
#define BAUD_RATE       115200      // Velocidad de Transmisión (Bauds))
                                    // Velocidades Permitidas:
                                    // 300, 600, 1200, 2400, 4800, 9600,
                                    // 14400, 19600, 28800, 38400, 57600
                                    // 115200, 230400
#define BT_App_Type     0           // App en el Celular: 0=Estandar 1=Emulador                                 
#if BT_App_Type == 0                                                      
#define BT_BAUD_RATE    38400       // Velocidad Estandar Bluetoothclado (default)
#endif
#if BT_App_Type == 1         
#define BT_BAUD_RATE    9600        // Velocidad de Emulación Terminal Serial
#endif

/*
*===============================================================================
*
*           C O N F I G U R A C I O N    D E    P U E R T O S
*
*===============================================================================
*/
Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor (Interno)
DigitalOut  led_testigo(PB_12);     // Inicializa el LED Testigo (Externo)
DigitalOut  Led_Verde(PB_13);       // Inicializa el PWM2 (PA6_TIM1_CH1N)  Led VERDE
DigitalOut  Led_Rojo(PB_14);        // Inicializa el PWM3 (PA7_TIM1_CH2N)  Led ROJO
DigitalOut  Led_Azul(PB_15);        // Inicializa el PWM1 (PB0_TIM1_CH3N)  Led AZUL
DigitalOut  key_pin(PB_5,HIGH);     // Inicializa el KEY pin o STATE pin (AT Commnands)
PwmOut      pwm1(PA_7);             // Inicializa el PWM para el LED Externo
PwmOut      buzzer(PB_0);           // Inicializa el PWM para el Buzzer Externo
AnalogIn    Sensor1(PA_0);          // Inicializa Canal Analógico para Potenciometro 1
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial UART_2 a la PC (Tx, Rx)
Serial      bluetooth(PB_10, PB_11);// Inicializa la Comunicación Serial UART_3 sobre Bluetooth (Tx, Rx)
//Serial      bluetooth(PA_9, PA_10); // Inicializa la Comunicación Serial UART1 sobre Bluetooth (Tx, Rx)
//Serial      bluetooth(PB_6, PB_7);  // Inicializa la Comunicación Serial UART1 sobre Bluetooth (Tx, Rx)
/*
#===============================================================================
|
|                           A R E A   D E   D A T O S
|
#===============================================================================
*/
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=TICKER_RATE/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
uint8_t  estado=0;
uint8_t  caracter;
const char *buffer;
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void TimerInt_OnInterrupt(void);    // Vector de Interrupción del Ticker
void Setup(void);                   // Función de Inicialización del Sistema
void Config_BT(void);               // Función de Configuración del Bluetooth
void Caratula(void);                // Función que despliega la Caratula en la Terminal
void Eco(void);                     // Función que Transmite y Recibe entre Terminales
void Clear_Screen(void);            // Función que limpia la Pantalla de la Terminal
void Buzzer_Beep(void);             // Función que prueba del Buzzer
/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{
//+++++++++++++++++++ Secuencia  Principal +++++++++++++++++++++++++++++++++++++                              
//       Inicialización de variables, puertos, interrupciones y carátula                    
  key_pin = HIGH;       // Bluetooth en modo de Comandos AT
  Setup();              // Inicializa el Sistema
  Config_BT();          // Configura el Módulo Bluetooth
  Caratula();           // Imprime la Caratula de Inicio
//+++++++++++++++++++ Lazo Principal +++++++++++++++++++++++++++++++++++++++++++
//            El Lazo del Programa principal está aquí !!!  
  while (true)
  {
    Eco();   // Hace ECO la terminal Serial con la terminal Bluetooth y viceversa.
  }
}
/* END main */

/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::              V E C T O R E S    D E    I N T E R R U P C I Ó N
::                      (Rutinas de Atención)
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
/*
** ===================================================================
**     Vector      :  TimerInt_OnInterrupt()
*/
/*!
**     @brief
**         Called after Ticker is done, [Interrupt service/event]
**         and it is enabled: 
**         TimerInt.attach_us(&TimerInt_OnInterrupt, TICKER_RATE);
**         the event is enabled and will be executed every  [TICKER_RATE]
**     @param
**         UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer is passed
**                           as the parameter of Init method.
*/
/* ===================================================================*/
void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
 //       terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (LED Toggled)
        counter = Rate;             // Restablece el contador, Le asigna el periodo de 0.5ms (Rate=500)
    } 
}
/* END Events */   
/*
 ______________________________________________________________________________
/______________________________________________________________________________\
|                                                                              |
|                   F U N C I O N E S     P R O T O T I P O                    |
|______________________________________________________________________________|
 \_____________________________________________________________________________/
*/
                // Las Funciones Prototipo van aquí !
/*
|--------------------------------------------------
|    Función Setup()
|--------------------------------------------------
*/
void Setup()
{
  confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
  terminal.baud(BAUD_RATE);   // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  Clear_Screen();             // Limpia la pantalla de la Terminal
  Buzzer_Beep();              // Prueba el Buzzer
  terminal.printf("The System is Wake Up!.\n\r");
  wait (2);                   // Espera 2 segundos
  TimerInt.attach_us(&TimerInt_OnInterrupt, TICKER_RATE);   // Le asigna el periodo de interrupción de 1ms (TICKER_RATE=1000)
  Clear_Screen();             // Limpia la pantalla de la Terminal
}
/*
|--------------------------------------------------
|    Función Config_BT()
|--------------------------------------------------
*/
void Config_BT()             // Software Bluetooth Initialization 
{
/*    
    key_pin = HIGH;         // Entramos al modo de Comandos AT
    bluetooth.baud(38400);  // Velocidad del Módulo Bluetooth para comandos AT.
    wait_ms(25);            // Espermos a que se estabilize el reloj
    bluetooth.printf("AT\r\n");         // Configura el nombre de la terminal Bluetooth.        
    bluetooth.printf("AT+ROLE=0\r\n");  // Configura el módulo Bluetooth como "Esclavo". 
    bluetooth.printf("AT+NAME=BluePill\r\n");   // Configura el nombre de la terminal Bluetooth.
//    bluetooth.printf("AT+PSWD=4321\r\n");      // Configura el password de la terminal Bluetooth.      
    bluetooth.printf("AT+VERSION?\r\n");// Muestra la Versión del Módulo Bluetooth.    
    bluetooth.printf("AT+ADDR?\r\n");   // Muestra la Dirección de la terminal Bluetooth.    
    bluetooth.printf("AT+UART?\r\n");   // Muestra la Velocidad de Transmisión de la terminal Bluetooth.       
    key_pin=HIGH;                    // Inhibe al HC-05 para recibir commandos AT
    bluetooth.baud(9600); // Velocidad del Módulo Bluetooth para datos AT.
//    terminal.baud(BT_BAUD_RATE);   // Configura la velocidad del Módulo Bluetooth.  
    bluetooth.printf("The Bluetooth is configuring Sucesfully!.\n\r"); 
    wait_ms(25);        
*/
    key_pin = HIGH;         // Entramos al modo de Comandos AT
//    bluetooth.baud(9600); // Velocidad del Módulo Bluetooth para datos AT.
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.baud(38400);  // Velocidad del Módulo Bluetooth para comandos AT.
    wait_ms(25);            // Espermos a que se estabilize el reloj
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.printf("AT\r\n");         // Configura el nombre de la terminal Bluetooth.
    wait_ms(5);                         // Espermos a que responda la terminal Bluetooth.
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.        
    bluetooth.printf("AT+ROLE=1\r\n");  // Configura el módulo Bluetooth: 0="Esclavo", 1="Maestro". 
    wait_ms(5);                         // Espermos a que responda la terminal Bluetooth.
//    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
//    bluetooth.printf("AT+CMODE=1\r\n");   // Selecciona/Verifica el modo de conección: 0 - A dirección fija 1 - A cualquier dirección, 2 - Lazo de Esclavo
//    wait_ms(5);                         // Espermos a que responda la terminal Bluetooth.
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.printf("AT+NAME=BluePill\r\n");   // Configura el nombre de la terminal Bluetooth.
    wait_ms(5);                         // Espermos a que responda la terminal Bluetooth.
//    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
//    bluetooth.printf("AT+PSWD=4321\r\n");      // Configura el password de la terminal Bluetooth.
//    wait_ms(5);                         // Espermos a que responda la terminal Bluetooth.
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.      
    bluetooth.printf("AT+VERSION?\r\n");// Muestra la Versión del Módulo Bluetooth.    
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.printf("AT+ADDR?\r\n");   // Muestra la Dirección de la terminal Bluetooth.    
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.printf("AT+UART?\r\n");   // Muestra la Velocidad de Transmisión de la terminal Bluetooth.       
    key_pin=LOW;                        // Inhibe al HC-05 para recibir commandos AT
//    bluetooth.baud(BT_BAUD_RATE);   // Configura la velocidad del Módulo Bluetooth.  
    bluetooth.baud(9600);   // Velocidad del Módulo Bluetooth para datos AT.
    wait_ms(25);
    terminal.printf("The \e[1;34;40mBluetooth\e[m was configurated Sucesfully!.\n\r"); 
    wait_ms(25);
    if (bluetooth.writable())           // Espermos para poder escribir en el Bluetooth.
    bluetooth.printf("The \e[1;34;40mBluetooth\e[m is ready to Paring!.\n\r");
}
/*
|--------------------------------------------------
|    Función Caratula()
|--------------------------------------------------
*/
void Caratula()
{
  terminal.printf ("\t\e[1;37;41mInstituto Politecnico Nacional\e[0m\n\r");
  terminal.printf ("\e[1;37;42mESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m\n\r\v");
  terminal.printf ("\t\e[1;31;40mPrueba \e[1;35;40mde \e[1;33;40mla \e[1;32;40mTerminal \e[1;34;40mBluetooth \e[0m\n\r\v\v\e[0m");
//  terminal.printf ("\t\e[1;32;40mTerminal Serial Lista!\n\r");
//  bluetooth.printf ("\t\e[1;34;40mTerminal Bluetooth Lista!\n\r");
}
/*
|--------------------------------------------------
|    Función Eco()
|--------------------------------------------------
*/
void Eco()                          // Eco a la Terminal
{
   if (bluetooth.readable())
   {
      caracter=bluetooth.getc();    // Si llega un dato por el puerto BT
//      wait_ms(5);                   // Espera a que se desocupe la terminal
//      if (terminal.writable())      // Si se peude escribir a la Terminal
      terminal.printf("\e[1;34;40m%c",caracter);     // se envía al monitor serial
      if (bluetooth.writable())
      bluetooth.putc(caracter);     // y hace ECO con la terminal BT
   }
 
   if (terminal.readable())
   {
      caracter=terminal.getc();     // Si llega un dato por el monitor serial
//      if (bluetooth.writable())
      bluetooth.putc(caracter);     // se envía al puerto BT
      terminal.printf("\e[1;32;40m%c",caracter);    // y hace ECO con el monitor serial
   }
}    
/*
|--------------------------------------------------
|    Función Clear_Screen()
|--------------------------------------------------
*/
void Clear_Screen() 
{
    // ANSI Terminal Commands
    terminal.printf("\x1B[2J");     // secuencia de Escape  \e1B[2J
    terminal.printf("\x1B[H");      // secuencia de Escape  \e1B[H
}
/*
|--------------------------------------------------
|    Función Buzzer_Beep()
|--------------------------------------------------
*/
void Buzzer_Beep()                      // Software routine for Buzzer Beep
{ 
  terminal.printf("Testing Buzzer... \n\r");
  buzzer = BUZZ_ON;
  wait_ms(750);
  buzzer = BUZZ_OFF;
  wait_ms(125);
  buzzer = BUZZ_ON;
  wait_ms(250);
  buzzer = BUZZ_OFF;
  wait_ms(125);
  buzzer = BUZZ_ON;
  wait_ms(500);
  buzzer = BUZZ_OFF;
  terminal.printf("Buzzer OK ! \n\r");
}
//comentario
/* END functions */    
                
/* END program */

/*
*+******************************************************************************
*+                  D O C U M E N T A C I Ó N
*+******************************************************************************
*+                  La documentación va aquí!:
*+
*+------------------------------------------------------------------------------      
*+                  MODULO BLUETOOTH HC-05
*+------------------------------------------------------------------------------ 
*+ 
*+                  PIN CONFIGURATION
*+
*+
*+ Pin Number   Pin Name        Description
*+    1         Enable/Key      This pin is used to toggle between 
*+                              Data Mode (set LOW) and AT command mode (set HiGH). 
*+                              By default it is in Data mode
*+    2         Vcc             Powers the module. Connect to +5V Supply voltage
*+    3         Ground          Ground pin of module, connect to system ground.
*+    4         TX–Transmitter  Transmits Serial Data. Everything received via 
**                              Bluetooth will be given out by this pin as serial data.
*+    5         RX–Receiver     Receive Serial Data. Every serial data given to    
*+                              this pin will be broadcasted via Bluetooth
*+    6         State           The state pin is connected to on board LED, it 
*+                              can be used as a feedback to check if Bluetooth 
*+                              is working properly.
*+    7         LED             Indicates the status of Module:
*+                            * Blink once in 2 sec: Module has entered Command Mode
*+                            * Repeated Blinking: Waiting for connection in Data Mode
*+                            * Blink twice in 1 sec: Connection successful in Data Mode
*+    8         Button          Used to control the Key/Enable pin to toggle between 
*+                              Data and command Mode
*+
*+  HC-05 Default Settings
*+
*+  Default Bluetooth Name:     “HC-05”
*+  Default Password:           1234 or 0000
*+  Default Communication:      Slave
*+  Default Mode:               Data Mode
*+  Data Mode Baud Rate:        9600, 8, N, 1
*+  Command Mode Baud Rate:     38400, 8, N, 1
*+  Default firmware:           LINVOR
*+ 
*+  HC-05 Technical Specifications
*+
*+  Serial Bluetooth module for Arduino and other microcontrollers
*+  Operating Voltage:          4V to 6V (Typically +5V)
*+  Operating Current:          30mA
*+  Range:                      <100m
*+  Supported baud rate:        9600,19200,38400,57600,115200,230400,460800.
*+  Works with Serial communication (USART) and TTL compatible
*+  Follows IEEE 802.15.1 standardized protocol
*+  Uses Frequency-Hopping Spread spectrum (FHSS)
*+  Can operate in Master, Slave or Master/Slave mode
*+  Can be easily interfaced with Laptop or Mobile phones with Bluetooth
*+
*+
*+  Cómo utilizar el módulo Bluetooth HC-05
*+
*+  El HC-05 tiene dos modos de funcionamiento, uno es el modo de datos en el 
*+  que puede enviar y recibir datos de otros dispositivos Bluetooth y el otro 
*+  es el modo de comando AT donde se puede cambiar la configuración predeterminada 
*+  del dispositivo. Podemos operar el dispositivo en cualquiera de estos dos 
*+  modos usando el pin clave como se explica en la descripción del pin.
*+
*+  Es muy fácil emparejar el módulo HC-05 con microcontroladores porque opera 
*+  utilizando el Protocolo de Puerto Serie (SPP). Simplemente encienda el módulo 
*+  con + 5V y conecte el pin Rx del módulo al Tx del MCU y el pin Tx del módulo 
*+  al Rx del MCU como se muestra en la siguiente figura
*+ 
*+ Para este ejemplo disponemos de un módulo Bluetooth HC-05 que podemos 
*+ conectar al puerto Serial de la Blue Pill. 
*+ Resumidamente hemos de conectar los pines de recepción (RX) y transmisión (TX); 
*+ que por defecto son los pines 0 y 1 respectivamente de nuestra placa con los 
*+ pines de transmisión (TX) y recepción (RX) del módulo de forma inversa; 
*+ tal y como se indica en la figura.
*+ 
*+   Módulo HC-05          Blue Pill                PIN
*+     KEY (EN) <----------  KEY_pin (ENable)       PB_1
*+     VCC      -----------  5V (algunos módulos pueden operar a 3.3V)
*+     GND      -----------  GND
*+     Tx       ---------->  Rx                     PB_11
*+     Rx       <----------  Tx                     PB_10
*+
*+ Lo más importante a tener en cuenta es que debemos de activar el modo de 
*+ configuración del Bluetooth a través de el PIN EN o KEY, que debe de estar 
*+ activo con un voltaje y que en este caso conectacmos al pin de 3,3V.
*+
*+ ATENCIÓN: Hay algunos módulos HC-05 que disponen de un botón diminuto y que 
*+ hay que apretar antes de conectarlo a la alimentación. En el momento en el 
*+ que entre en modo configuración; el LED parpadeará más lento de lo normal y 
*+ podemos verificar que ha cambiado de modo.
*+
*+  Conexiones del circuito del módulo Bluetooth HC-05
*+
*+  Durante el encendido, el pin de key puede conectarse a tierra para 
*+  entrar en el modo de comando; si se deja libre, entrará de forma predeterminada 
*+  en el modo de datos. Tan pronto como se encienda el módulo, debería poder 
*+  encontrar el dispositivo Bluetooth como “HC-05”, luego conéctese con la 
*+  contraseña predeterminada 1234 y comience a comunicarse con él. 
*+  El nombre de la contraseña y otros parámetros predeterminados se pueden 
*+  cambiar ingresando al modo de configuración.
*+
*+ Para poder comunicarse en modo configuración a través de la placa Blue Pill
*+ es necesario configurar la velocidad de transmisión hacia la tarjeta HC-05 a
*+ 38400 Bauds
*+
*+ 1. Dispositivos Bluetooth:
*+ El módulo Bluetooth HC-05 viene configurado de fábrica como "Esclavo" (slave),
*+ pero se puede cambiar para que trabaje como "maestro" (master), además al
*+ igual que el HC-06, se puede cambiar el nombre, código de vinculación,
*+ velocidad y otros parámetros más.
*+
*+ Definamos primero que es un dispositivo bluetooth maestro y dispositivo esclavo:
*+
*+ Modulo bluetooth hc-05 como esclavo:
*+ Cuando está configurado de esta forma, se comporta similar a un HC-06, espera
*+ que un dispositivo bluetooth maestro se conecte a este, generalmente se
*+ utiliza cuando se necesita comunicarse con una PC o Celular, pues estos se
*+ comportan como dispositivos maestros.
*+
*+ Modulo bluetooth hc-05 como Maestro:
*+ En este modo, EL HC-05 es el que inicia la conexión. Un dispositivo maestro
*+ solo se puede conectarse con un dispositivo esclavo. Generalmente se utiliza
*+ este modo para comunicarse entre módulos bluetooth. Pero es necesario antes
*+ especificar con que dispositivo se tiene que comunicar, esto se explicará más
*+ adelante
*+
*+ El módulo HC-05 viene por defecto configurado de la siguiente forma:
*+  - Modo o role: Esclavo
*+  - Nombre por defeco: HC-05
*+  - Código de emparejamiento por defecto: 1234
*+  - La velocidad por defecto (baud rate): 9600
*+
*+ 2. Modos de trabajo del HC-05::
*+ EL Modulo HC-05 tiene 4 estados los cuales es importante conocer:
*+ 
*+ Estado Desconectado:
*+  - Entra a este estado tan pronto alimentas el modulo, y cuando no se ha
*+    establecido una conexión bluetooth con ningún otro dispositivo
*+  - EL LED del módulo en este estado parpadea rápidamente
*+  - En este estado a diferencia del HC-06, el HC-05 no puede interpretar los
*+    comandos AT
*+
*+ Estado Conectado o de comunicación
*+  - Entra a este estado cuando se establece una conexión con otro dispositivo
*+    bluetooth.
*+  - El LED hace un doble parpadeo.
*+  - Todos los datos que se ingresen al HC-05 por el Pin RX se trasmiten por
*+    bluetooth al dispositivo conectado, y los datos recibidos se devuelven por
*+    el pin TX. La comunicación es transparente
*+
*+ Modo AT 1
*+  - Para entrar a este estado después de conectar y alimentar el modulo es
*+    necesario presionar el botón del HC-05.
*+  - En este estado, podemos enviar comandos AT, pero a la misma velocidad con
*+    el que está configurado.
*+  - EL LED del módulo en este estado parpadea rápidamente igual que en el
*+    estado desconectado.
*+ 
*+ Modo AT 2
*+  - Para entrar a este estado es necesario tener presionado el botón al momento
*+    de alimentar el modulo, es decir el modulo debe encender con el botón
*+    presionado, después de haber encendido se puede soltar y permanecerá en
*+    este estado.
*+  - En este estado, para enviar comandos AT es necesario hacerlo a la velocidad
*+    de 38400 baudios, esto es muy útil cuando nos olvidamos la velocidad con
*+    la que hemos dejado configurado nuestro modulo.
*+  - El LED del módulo en este estado parpadea lentamente.
*+  
*+ Los siguientes pasos son para entrar al Modo AT 1 o Modo AT 2:
*+
*+  -Para entrar al modo AT 1, después de alimentar el modulo y haber encendido
*+                             tan solo basta presionar el botón que tiene el
*+                             módulo HC-05, el LED del módulo seguirá parpadeando
*+                             rápidamente, por lo que para saber si hemos entrado
*+                             al Modo AT 1 es necesario enviar comandos AT y ver
*+                             si responde,  estos comandos se verán más adelante.
*+  -Para entrar al modo AT 2, antes de alimentar o encender el modulo es necesario
*+                             presionar su botón, mantener presionado y alimentar
*+                             el modulo, después que enciende recién podemos
*+                             soltar el botón. Si el LED Parpadea lentamente es
*+                             porque ya está en Modo AT 2.
*+
*+ En este tutorial enviaremos los comandos AT usando el Modo AT 2, pero también
*+ es válido si están en el Modo AT 1, con la diferencia que tendrán que cambiar
*+ a la velocidad con la que tienen configurado su Bluetooth (si es la primera
*+ vez que configuran, la velocidad por defecto es de 9600).
*+
*+ Ahora abrimos nuestro Monitor serial Tera Term, pero puedes usar
*+ cualquier monitor serial.
*+
*+ En la opción Setup --> Terminal debemos escoger “Ambos LF & CR”  y la velocidad
*+ “38400 baud” (la velocidad para comunicarse en el MODO AT 2) 
*+      
*+ Echo esto Podemos empezar a enviar los comandos AT a nuestro Bluetooth
*+
*+ Test de comunicación
*+ Lo primero es comprobar si nuestro bluetooth responde a los comandos AT
*+
*+ Enviar: AT
*+ Recibe: OK
*+
*+ Si recibimos como respuesta un OK entonces podemos continuar, sino verificar
*+ las conexiones o los pasos anteriores.
*+
*+
*+-----------------------------------------------------------------------------       
*+
*+                  MODULO BLUETOOTH HC-05
*+
*+  El módulo HC-05 es un módulo Bluetooth SPP (protocolo de puerto serie) 
*+  fácil de usar, diseñado para una configuración de conexión serial inalámbrica
*+  transparente. El módulo Bluetooth de puerto serie está totalmente calificado
*+  como Bluetooth V2.0 + EDR (Velocidad de datos mejorada) Modulación de 3Mbps 
*+  con transceptor de radio y banda base completos de 2.4GHz.
*+  Utiliza el sistema Bluetooth CSR Bluecore 04-External de un solo chip con 
*+  tecnología CMOS y con AFH (función de salto de frecuencia adaptable).
*+  Tiene una huella tan pequeña como 12.7 mm x 27 mm. 
*+
*+  Características del software
*+  
*+ o Velocidad de transmisión predeterminada: 
*+   38400 bauds, Bits de datos: 8, Bit de parada: 1, Paridad: Sin paridad, 
*+   Control de datos: tiene. 
*+   Velocidad de transmisión permitidas:
*+   9600,19200,38400,57600,115200,230400,460800.
*+ o Dado un pulso ascendente en PIO0, el dispositivo se desconectará.
*+ o Puerto de instrucción de estado PIO1: Bajo=desconectado, Alto=conectado;
*+ o PIO10 y PIO11 se pueden conectar al led rojo y azul por separado.
*+   Cuando el maestro y el esclavo están emparejados, el LED rojo y azul 
*+   parpadea en intervalo de 1 vez/2s, mientras que el LED azul parpadea solo
*+   2 veces/s.
*+ o Se conecta automáticamente al último dispositivo con alimentación de forma
*+   predeterminada. 
*+ o Permitir que el dispositivo se conecte de forma predeterminada.
*+ o CÓDIGO PIN de emparejamiento automático: "0000" por defecto
*+ o Reconexión automática en 30 minutos cuando se desconecta como resultado
*+   de un rango de conexión más allá.
*+
*+ Características de hardware
*+
*+  Sensibilidad típica de -80dBm
*+  Hasta + 4dBm de potencia de transmisión de RF
*+  Operación de baja potencia  E/S de 1.8V a 3.6V 
*+  Control PIO
*+  Interfaz UART con velocidad de transmisión programable
*+  Con antena integrada
*+  Con conector de borde
*+
*+  Conexión al Módulo Bluetooth HC-05:
*+  
*+                                                   /
*+  BluePill                       HC-05            /
*+                              1 Enable/Key    ---o   o---> GND  
*+    3.3V          ------      2 Vcc
*+    GND           ------      3 GND 
*+    Rx (PB_11)    <-----      4 Tx 
*+    Tx (PB_10)    ----->      5 Rx
*+                              6 State         -----------> IRQ
*+ 
*+  Comandos AT Soportados 
*+
*+  Cómo configurar el modo a servidor (maestro): 
**  1. Conecte PIO11 a nivel alto. (pin 34)
*+  2. Encendido, módulo en estado de comando 
*+  3. Usando la velocidad en baudios 38400, se envía el comando 
*+       "AT+ROLE=1\r\n" 
*+     al módulo, con una respuesta de
*+       "OK\r\n" 
*+     significa establecer éxitos. 
*+  4. Conecte el PIO11 a nivel bajo, vuelva a encender el módulo, el módulo
*+     funciona como servidor (maestro).
*+
*+   Comandos AT:(todos terminan con \r\n)
*+  1. Test command:
*+      Comando         Respuesta           Parámetros 
*+      AT              OK                  -
*+  2. Reset:
*+      Comando         Respuesta           Parámetros 
*+      AT+RESET        OK                  -
*+  3. Get firmware version
*+      Comando         Respuesta           Parámetros 
*+      AT+VERSION?     +VERSION:<Param>    Param : firmware version
*+                      OK 
*+
*+   Ejemplo:
*+      AT+VERSION?\r\n 
*+      +VERSION:2.0-20100601 
*+      OK 
*+
*+  4. Restore default
*+      Comando         Respuesta           Parámetros 
*+      AT+ORGL         OK                  -
*+
*+    Estado por Omisión:
*+      Slave mode, pin code :1234, device name: H-C-2010-06-01 ,Baud 38400bits/s.
*+       
*+  5. Get moduleaddress
*+      Comando         Respuesta           Parámetros 
*+      AT+ADDR?        +ADDR:<Param>       Param:  address of Bluetooth Module
*+                      OK                  
*+
*+       Bluetooth address: NAP: UAP : LAP
*+       
*+   Ejemplo: 
*+      AT+ADDR?\r\n
*+      +ADDR:1234:56:abcdef
*+      OK
*+
*+  6. Set/Check module name
*+      Comando         Respuesta           Parámetros 
*+      AT+NAME=<Param> OK                  Param: Bluetooth module name
*+      AT+NAME?        +NAME:<Param>              (Default: HC-05)
*+                      OK (/FAIL)
*+
*+   Ejemplo:
*+      AT+NAME=HC-05\r\n       set the module name to “HC-05”
*+      OK 
*+      AT+NAME=BluePill\r\n    set the module name to “BluePill”
*+      OK                                                 
*+      AT+NAME?\r\n
*+      +NAME: BluePill
*+      OK 
*+
*+  7. Get the Bluetooth device name:
*+      Comando         Respuesta           Parámetros 
*+    AT+RNAME?<Param1> 1. +NAME:<Param2>   Param1,Param2: the address of 
*+                      OK                  Bluetooth device
*+                      2. FAIL
*+
*+   Ejemplo:(Device address 00:02:72:od:22:24，name：BluePill)
*+      AT+RNAME? 0002，72，od2224\r\n 
*+      +RNAME:BluePill
*+      OK
*+       
*+  8.Set/Check module mode:
*+      Comando         Respuesta           Parámetros
*+      AT+ROLE=<Param> OK                  Param:
*+      AT+ ROLE?       +ROLE:<Param>          0-Slave
*+                                             1-Master
*+      
*+  9. Set/Check device class     
*+      Comando         Respuesta           Parámetros
**    AT+CLASS=<Param>  OK                  Param: Device Class
*+    AT+ CLASS?        1. +CLASS:<Param>
*+                      OK
*+                      2. FAIL
*+                     
*+  10. Set/Check GIAC (General Inquire Access Code)
*+      Comando         Respuesta           Parámetros
*+    AT+IAC=<Param>    1.OK                Param: GIAC
*+                      2.FAIL             (Default: 9e8b33)
*+    AT+IAC            +IAC:<Param>  
 *+                     OK
 *+
*+   Ejemplo:
*+      AT+IAC=9e8b3f\r\n 
*+      OK
*+      AT+IAC?\r\n 
*+      +IAC: 9e8b3f 
*+      OK
*+
*+  11. Set/Check --Query access patterns
*+      Comando         Respuesta           Parámetros
*+    AT+INQM=<Param>,  1.OK                Param: 
*+    <Param2>,         2.FAIL                 0——inquiry_mode_standard
*+    <Param3>                                 1——inquiry_mode_rssi
*+                                          Param2:
*+                                             Maximum number of Bluetooth
*+                                             devices to respond to
*+                                          Param3:
*+                                             Timeout (1-48 : 1.28s to 61.44s)
*+
*+   Ejemplo:
*+      AT+INQM=1,9,48\r\n
*+      OK AT+INQM\r\n 
++      +INQM: 1, 9, 48 
*+      OK
*+  
*+  12. Set/Check PIN code:
*+      Comando         Respuesta           Parámetros
*+     AT+PSWD=<Param>  OK                  Param: PIN code(Default 1234)
*+     AT+ PSWD?        + PSWD：<Param>
*+                      OK
*+
*+  13. Set/Checkserial parameter:
*+      Comando         Respuesta           Parámetros
*+     AT+UART=<Param>, OK                  Param1: Baud
*+      <Param2>,                           Param2: Stop bit
*+      <Param3>                            Param3: Parity
*+    AT+ UART?         +UART=<Param>,
*+                      <Param2>, 
*+                      <Param3> 
*+                      OK
*+  Ejemplo:
*+    AT+UART=115200，1,2,\r\n
*+    OK
*+    AT+UART? 
*+    +UART:115200,1,2
*+    OK
*+
*+  14. Set/Check connect mode:
*+      Comando         Respuesta           Parámetros
*+    AT+CMODE=<Param>  OK                  Param:
*+    AT+ CMODE?        + CMODE:<Param>        0 - connect fixed address
*+                      OK                     1 - connect any address
*+                                             2 - slave-Loop
*+
*+  15. Set/Check fixed address:
*+      Comando         Respuesta           Parámetros
**    AT+BIND=<Param>   OK                  Param: 
*+                      + BIND:<Param>         Fixed address
*+                      OK                     (Default 00:00:00:00:00:00)
*+
*+  Ejemplo:
*+    AT+BIND=1234，56，abcdef\r\n
*+    OK
*+    AT+BIND?\r\n
*+    +BIND:1234:56:abcdef
*+    OK
*+
*+  16. Set/Check LED I/O
*+      Comando         Respuesta           Parámetros
*+   AT+POLAR=<Param1,  OK                  Param1: 
*+            <Param2>                         0-PIO8 low  drive LED
*+   AT+ POLAR?         +POLAR=<Param1>,       1-PIO8 high drive LED
*+                             <Param2>     Param2: 
**                                             0-PIO9 low  drive LED
**                                             1-PIO9 high drive LED
*+  17. Set PIO output
*+      Comando         Respuesta           Parámetros
*+  AT+PIO=<Param1>,    OK                  Param1:
*+         <Param2>                            PIO number
*+                                          Param2:
*+                                             PIO level
*+                                              0-low
*+                                              1-high
*+  Ejemplo:
*+    1. PIO10 output high level
*+    AT+PI0=10,1\r\n
*+    OK
*+
*+  18. Set/Check –scan parameter
*+      Comando         Respuesta           Parámetros
*+  AT+IPSCAN=<Param1>, OK                  Param1: Query time interval
*+            <Param2>,                     Param2：Query duration
*+            <Param3>,                     Param3：Paging interval
*+            <Param4>                      Param4：Call duration
*+  AT+IPSCAN?          +IPSCAN:<Param1>,
*+                              <Param2>,
*+                              <Param3>,
*+                              <Param4>
*+                      OK
*+   Ejemplo:
*+      AT+IPSCAN=1234,500,1200,250\r\n
*+      OK 
*+      AT+IPSCAN? 
*+      +IPSCAN:1234,500,1200,250 
*+
*+  19. Set/Check –SHIFF parameter
*+      Comando         Respuesta           Parámetros
*+  AT+SNIFF=<Param1>,  OK                  Param1: Max time
*+           <Param2>,                      Param2: Min time 
*+           <Param3>,                      Param3: Retry time
*+           <Param4>                       Param4: Time out
*+  AT+SNIFF?           +SNIFF:<Param1>,
**                             <Param2>,
**                             <Param3>,
*+                             <Param4> 
*+                      OK
*+
*+  20. Set/Check securitymode
*+      Comando         Respuesta           Parámetros
*+  AT+SENM=<Param1>,   1.OK                Param1:  
*+          <Param2>    2.FAIL                 0——sec_mode0+off
*+  AT+ SENM?           +SENM:<Param1>,        1——sec_mode1+non_secure
*+                            <Param2>         2——sec_mode2_service 
*+                      OK                     3——sec_mode3_link 
*+                                             3——sec_mode3_link 
*+                                             4——sec_mode_unknown 
*+                                          Param2:
**                                             0——hci_enc_mode_off 
*+                                             1——hci_enc_mode_pt_to_pt
*+                                             2——hci_enc_mode_pt_to_pt_and_bcast
*+
*+  21. DeleteAuthenticated Device
*+      Comando         Respuesta           Parámetros
*+  AT+PMSAD=<Param>    OK                  Param: Authenticated Device Address  
*+
*+  Ejemplo:
*+     AT+PMSAD=1234,56,abcdef\r\n 
*+     OK