// Includes ---------------------------------------------------------------------------------------
#include "mbed.h"
#include "TextLCD.h"

// Objects ----------------------------------------------------------------------------------------
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7, 16char, 2 lines
Ticker ticker;
time_t currentTime;

const int UPDATE_FREQ = 1; // sec
char lcdBuffer[32]; // buffer for LCD (32=2x16)

// Function prototypes ---------------------------------------------------------------------------
void displayOnLcd();
void updateRealTimeClock(char *buffer);
void getLineFromSerial(char *keyBuffer, int bufferLength);
void displayMessageOnConsole();

// Main  -------------------------------------------------------------------------------------
int main() {
    
    char lineBuffer[32];
    char *pointer;
    pointer = lineBuffer;
    
    // update time for every UPDATE_FREQ sec
    ticker.attach(&displayOnLcd, UPDATE_FREQ);

    // 
    for(;;) {
        // show initial message on console
        displayMessageOnConsole();
        
        // get input from console
        getLineFromSerial(pointer, sizeof(lineBuffer));
        
        // update RTC based on input value
        updateRealTimeClock(pointer);        
    }
}

// Functions -------------------------------------------------------------------------------------
// Display Current Time on LCD
void displayOnLcd() {
        myled = !myled;

    currentTime = time(NULL);
    strftime(lcdBuffer, 32, "%Y/%m/%d  %H:%M:%S", localtime(&currentTime));

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("RTC:%s", lcdBuffer);

    myled = !myled;      
};

// Update RTC
void updateRealTimeClock(char *buffer) {
    char *tp;
    char *timeArray[6];
    int arrayIndex;
    struct tm struct_time;
    
    // extract number from string
    arrayIndex = 0;
    tp = strtok( buffer, " /:-" );
    timeArray[arrayIndex++] = tp;
    printf("%d ", atoi(tp));
    while ( tp != NULL && arrayIndex < 6 ) {
        tp = strtok( NULL," /:-" );
        timeArray[arrayIndex++] = tp;
        if ( tp != NULL ) {
            printf("%d ", atoi(tp));
        }
    }
    printf("\r\n");
    
    // store number into time struct   
    struct_time.tm_year = atoi(timeArray[0]) - 1900;
    struct_time.tm_mon  = atoi(timeArray[1]) - 1;
    struct_time.tm_mday = atoi(timeArray[2]);
    struct_time.tm_hour = atoi(timeArray[3]);
    struct_time.tm_min  = atoi(timeArray[4]);
    struct_time.tm_sec  = atoi(timeArray[5]);

    currentTime = mktime(&struct_time);
    set_time(currentTime);
}

// Read & display input data from console
void getLineFromSerial(char *keyBuffer, int bufferLength)
{
    char c;
    int index = 0;
 
    for (;;) {
        // break if keyBuffer is full
        if (index >= bufferLength) {
            break;
        }

        // read input
        c = pc.getc();
        pc.putc(c);
        
        // break if end
        if (c == '\r') {
            keyBuffer[index++] = c;
            printf("\n");
            break;
        }

        // store in keyBuffer
        keyBuffer[index++] = c;        
    }
}

// display message and ask user to input time
void displayMessageOnConsole() {
    currentTime = time(NULL);
    strftime(lcdBuffer, 32, "%Y/%m/%d %H:%M:%S", localtime(&currentTime));

    printf("Current Time:%s\r\n", lcdBuffer);
    printf("Enter new Time (YYYY/mm/dd HH:MM:SS)\r\n");
}

