/******************************************************************************
main.cpp

Tatsuya Iwai @ greysound.com
Original Creation Date: Aug 12, 2016
https://github.com/sparkfun/LSM9DS1_Breakout

This simple program tests built-in "A" and "B" button on micro:bit or any
compatible devices (such as "chibi:bit") shows button label on LED matrix
when either button is pressed.

Distributed as-is; no warranty is given.
******************************************************************************/

#include "MicroBit.h"

// Objects --------------------------------------------------------------------
MicroBitMessageBus bus;
MicroBitButton buttonA(MICROBIT_PIN_BUTTON_A, MICROBIT_ID_BUTTON_A);
MicroBitButton buttonB(MICROBIT_PIN_BUTTON_B, MICROBIT_ID_BUTTON_B);
MicroBitDisplay display;

// Function prototypes --------------------------------------------------------
void onPressed(MicroBitEvent e);

// Main  ----------------------------------------------------------------------
int main()
{
    scheduler_init(bus);

    bus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onPressed);
    bus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onPressed);

    while(1)
        fiber_sleep(1000);
}

// Functions ------------------------------------------------------------------
void onPressed(MicroBitEvent e)
{
    if (e.source == MICROBIT_ID_BUTTON_A)
        display.scroll("A");

    if (e.source == MICROBIT_ID_BUTTON_B)
        display.scroll("B");
}