//
// uVGAIII is a class to drive 4D Systems TFT touch screens
//
// Copyright (C) <2010> Stephane ROCHON <stephane.rochon at free.fr>
//
// uVGAIII is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// uVGAIII is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with uVGAIII.  If not, see <http://www.gnu.org/licenses/>.

#include "mbed.h"
#include "uVGAIII.h"

#define SIZE_X       480
#define SIZE_Y       800

// overwrite 4DGL library screen size settings in uVGAIII.h

uVGAIII ecran(p9,p10,p11); // serial tx, serial rx, reset pin;

int main() {
    char c;
    
    printf("\n\n-----Starting-----\n\n");

    ecran.baudrate(128000);
    ecran.screen_mode(LANDSCAPE);
    ecran.graphics_parameters(RESOLUTION, 2);  // set screen resolution to 800*480
    ecran.touch_status();
    ecran.background_color(DGREY);
    ecran.cls();

    ecran.circle(120, 160, 80, CYAN);
    ecran.filled_triangle(320, 100, 340, 300, 500, 270, LIME);
    
    ecran.move_cursor(5, 60);
    ecran.char_width('d');
    ecran.char_height('d');
    ecran.text_fgd_color(MAGENTA);
    ecran.text_bgd_color(YELLOW);
    ecran.put_string("This is a test of string!\nHappy Pi Day :-)");
    
    ecran.move_cursor(10, 10);
    ecran.puts("This is a test of puts...\n");
    
    ecran.move_cursor(15, 98);
    ecran.printf("This is a test of printf!\rMew...\nYeah!");
    
    ecran.move_cursor(20,10);
    ecran.printf("Starting real-time display...\n\n");
    ecran.move_cursor(20,78);
    while((c=getchar())!= '~'){            // when type '~', exit the real time display
        ecran.printf("%c",c);
    }
    ecran.printf("\n\nClosing real-time display...\n");

    printf("\n\n-----Completed-----\n\n");
}