//
// uVGAIII is a class to drive 4D Systems TFT touch screens
//
// Copyright (C) <2010> Stephane ROCHON <stephane.rochon at free.fr>
//
// uVGAIII is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// uVGAIII is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with uVGAIII.  If not, see <http://www.gnu.org/licenses/>.

#include "mbed.h"
#include "uVGAIII.h"

//******************************************************************************************************
int uVGAIII :: touch_status(void) {      // Get the touch screen status
    char command[4] = "";
    
    command[0] = (TOUCHGET >> 8) & 0xFF;
    command[1] = TOUCHGET & 0xFF;
    
    command[2] = (STATUS >> 8) & 0xFF;
    command[3] = STATUS & 0xFF;
    
    return getSTATUS(command, 4);       
}

//******************************************************************************************************
void uVGAIII :: touch_get_x(int *x) {    // Get X coordinates
    char command[4] = "";
    
    command[0] = (TOUCHGET >> 8) & 0xFF;
    command[1] = TOUCHGET & 0xFF;
    
    command[2] = 0;
    command[3] = GETXPOSITION;
    
    getTOUCH(command, 4, x);
    
#if DEBUGMODE
    pc.printf("Get X coordinates completed.\n");
#endif
}

//******************************************************************************************************
void uVGAIII :: touch_get_y(int *y) {    // Get Y coordinates
    char command[4] = "";
    
    command[0] = (TOUCHGET >> 8) & 0xFF;
    command[1] = TOUCHGET & 0xFF;
    
    command[2] = 0;
    command[3] = GETYPOSITION;
    
    getTOUCH(command, 4, y);
    
#if DEBUGMODE
    pc.printf("Get Y coordinates completed.\n");
#endif
}

//******************************************************************************************************
void uVGAIII :: touch_set(char mode) {    // Sets various Touch Screen related parameters

    char command[4]= "";

    command[0] = (TOUCHSET >>8) & 0xFF;
    command[1] = TOUCHSET & 0xFF;

    command[2] = 0;
    command[3] = mode;

    writeCOMMAND(command, 4, 1);
    
#if DEBUGMODE
    pc.printf("Touch set completed.\n");
#endif
}

//******************************************************************************************************
void uVGAIII :: detect_touch_region(int x1, int y1, int x2, int y2) {   // Specificies a new touch detect region on the screen
    char command[10] = "";  
    
    command[0] = (TOUCHDETECT >> 8) & 0xFF;
    command[1] = TOUCHDETECT & 0xFF;
    
    command[2] = (x1 >> 8) & 0xFF;
    command[3] = x1 & 0xFF;

    command[4] = (y1 >> 8) & 0xFF;
    command[5] = y1 & 0xFF;

    command[6] = (x2 >> 8) & 0xFF;
    command[7] = x2 & 0xFF;

    command[8] = (y2 >> 8) & 0xFF;
    command[9] = y2 & 0xFF;

    writeCOMMAND(command, 10, 1);
    
#if DEBUGMODE
    pc.printf("Detect touch region completed.\n");
#endif 
}