#include "mbed.h"
#include "MRF24J40.h"

/**
* Receive data from the MRF24J40.
*
* @param mrf, RF tranceiver to link with
* @param data A pointer to a char array to hold the data
* @param maxLength The max amount of data to read.
*/
int rf_receive_rssi(MRF24J40 mrf, char *data, uint8_t *rssi, uint8_t maxLength) {
    uint8_t len = mrf.Receive_RSSI((uint8_t *)data, rssi, maxLength);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};

    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }
        //pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}