#include "mbed.h"
#include "MRF24J40.h"
#include "sender.h"
#include "analog_joystick.h"

#include <string.h>

// RF tranceiver to link with handheld.
MRF24J40 mrf(p11, p12, p13, p14, p21);

// LEDs you can treat these as variables (led2 = 1 will turn led2 on!)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Timer
Timer timer;

// Serial port for showing RX data.
Serial pc(USBTX, USBRX);

int main (void)
{
    long long id = 0;
    uint8_t channel = 3;

    //Set the Channel. 0 is default, 15 is max
    mrf.SetChannel(channel);

    //Start the timer
    timer.start();

    pc.printf("START\r\n");

    char txBuffer[250];


    float thrustOffset =0;
    float rollOffset =0;
    float pitchOffset =0;
    float yawOffset =0;

    int nSamples = 100;

    for (int n = 0; n < nSamples; n++) {
        thrustOffset += read_thrust();
        yawOffset += read_yaw();
        pitchOffset += read_pitch();
        rollOffset += read_roll();

    }
    thrustOffset /= nSamples;
    yawOffset /= nSamples;
    pitchOffset /= nSamples;
    rollOffset /= nSamples;


    while(1) {
        sprintf(txBuffer, "%lld,%f,%f,%f,%f", id, read_thrust()-thrustOffset, read_yaw()-yawOffset, read_pitch()-pitchOffset, read_roll()-rollOffset);
        rf_send(mrf, txBuffer, strlen(txBuffer) + 1);
        pc.printf("RC Sent: %s \r\n", txBuffer);

        id++;
    }
}
