#include "mbed.h"
#include "neopixels_spi.h"
#include <string.h>
#include <stdio.h>

/*
neopixel_spi v03
Created By: Ivan Yohuno
SSID: 200717683

Notes:
-Code to be run on WS2812 neopixel LEDs, can run with a single pixel or a strip of max 8 leds connected together
-Single LED can be connected to power source of 5V but if connected to 5V logic will need to be shifted up from 3.3V to 5V

Features:
-SetRGBPixel // sets colour of one RGB Pixel (the first pixel connected), generally used for testing. Colour is a mix of 3 8 bit values of red, green and blue
-SetRGBStrip // sets colour of RGB strip of 8
-setRGBStrips //sets colours of 4 RGB strips of 8 
    colours 2D 4x3 matrix:
    {{room 1 strip red, room 1 strip green, room 1 strip blue},
     {room 2 strip red, room 2 strip green, room 3 strip blue},
     {room 3 strip red, room 3 strip green, room 3 strip blue}
    } 
-SetRGBPixels // sets an RGB strip of 8 to individual colours using a 2D 8x3 matrix
    colours 2D 8x3 matrix:
    {{1st pixel red, 1st pixel blue, 1st pixel green},
     {2nd pixel red, 2nd pixel blue, 2nd pixel green}, 
     {3rd pixel red, 3rd pixel blue, 3rd pixel green},
     {4th pixel red, 4th pixel blue, 4th pixel green},
     {5th pixel red, 5th pixel blue, 5th pixel green},
     {6th pixel red, 6th pixel blue, 6th pixel green},
     {7th pixel red, 7th pixel blue, 7th pixel green},
     {8th pixel red, 8th pixel blue, 8th pixel green}
     } 

//function declarations 
//void setRGBPixel(int r, int g, int b); //sets colour of one RGB Pixel
void setRGBStrip1(int r, int g, int b); //sets colour of a strip of 8 RGB Pixels on pin 5
void setRGBStrip2(int r, int g, int b); //sets colour of a strip of 8 RGB Pixels on pin 11
void setRGBPixels1(int colours[8][3]); //sets sequence of colours for a strip of 8 RGB Pixels on pin 5
void setRGBPixels2(int colours[8][3]); //sets sequence of colours for a strip of 8 RGB Pixels on pin 11
void spi_init(); //initializes SPI pin at correct bit length and bit rate
int * decimalToBinary(int n); //converts a decimal value between 0 and 255 to an 8 bit binary array of 0xF00 (0) and 0xFF0 (1)
*/
//initialize pins 
//DigitalOut volt(p16); //pin for LV voltage
SPI spi(p5, p6, p7);//pin for SPI communication - p5 MOSI p5 MISO p6 SCLK
SPI spi2(p11, p12, p13);//pin for SPI communication - p5 MOSI p5 MISO p6 SCLK
//NeoStrip strip(p5,8);


void neopixels_spi::setRGBStrip1(int r, int g, int b){
    int r_array[8];
    int g_array[8];
    int b_array[8];
    memcpy(r_array, decimalToBinary(r), sizeof(r_array));
    memcpy(g_array, decimalToBinary(g), sizeof(g_array));
    memcpy(b_array, decimalToBinary(b), sizeof(b_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED1    
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED2
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED3
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED4
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED5
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED6
     //set green bits
     
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED7
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    
    //wait for latch 
    wait_us(60);
}

void neopixels_spi::setRGBStrip2(int r, int g, int b){
    int r_array[8];
    int g_array[8];
    int b_array[8];
    memcpy(r_array, decimalToBinary(r), sizeof(r_array));
    memcpy(g_array, decimalToBinary(g), sizeof(g_array));
    memcpy(b_array, decimalToBinary(b), sizeof(b_array));
    
    //send commands to LED Driver
     //initialize spi
     spi_init();
    //LED0
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED1    
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED2
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED3
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED4
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED5
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED6
     //set green bits
     
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED7
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    
    //wait for latch 
    wait_us(60);
}
    
void neopixels_spi::setRGBPixels1(int colours[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    int r0_array[8]; //LED0
    int g0_array[8];
    int b0_array[8];
    memcpy(r0_array, decimalToBinary(colours[0][0]), sizeof(r0_array));
    memcpy(g0_array, decimalToBinary(colours[0][1]), sizeof(g0_array));
    memcpy(b0_array, decimalToBinary(colours[0][2]), sizeof(b0_array));
    int r1_array[8]; //LED1
    int g1_array[8];
    int b1_array[8];
    memcpy(r1_array, decimalToBinary(colours[1][0]), sizeof(r1_array));
    memcpy(g1_array, decimalToBinary(colours[1][1]), sizeof(g1_array));
    memcpy(b1_array, decimalToBinary(colours[1][2]), sizeof(b1_array));
    int r2_array[8]; //LED2
    int g2_array[8];
    int b2_array[8];
    memcpy(r2_array, decimalToBinary(colours[2][0]), sizeof(r2_array));
    memcpy(g2_array, decimalToBinary(colours[2][1]), sizeof(g2_array));
    memcpy(b2_array, decimalToBinary(colours[2][2]), sizeof(b2_array));
    int r3_array[8]; //LED3
    int g3_array[8];
    int b3_array[8];
    memcpy(r3_array, decimalToBinary(colours[3][0]), sizeof(r3_array));
    memcpy(g3_array, decimalToBinary(colours[3][1]), sizeof(g3_array));
    memcpy(b3_array, decimalToBinary(colours[3][2]), sizeof(b3_array));
    int r4_array[8]; //LED4
    int g4_array[8];
    int b4_array[8];
    memcpy(r4_array, decimalToBinary(colours[4][0]), sizeof(r4_array));
    memcpy(g4_array, decimalToBinary(colours[4][1]), sizeof(g4_array));
    memcpy(b4_array, decimalToBinary(colours[4][2]), sizeof(b4_array));
    int r5_array[8]; //LED5
    int g5_array[8];
    int b5_array[8];
    memcpy(r5_array, decimalToBinary(colours[5][0]), sizeof(r5_array));
    memcpy(g5_array, decimalToBinary(colours[5][1]), sizeof(g5_array));
    memcpy(b5_array, decimalToBinary(colours[5][2]), sizeof(b5_array));
    int r6_array[8]; //LED6
    int g6_array[8];
    int b6_array[8];
    memcpy(r6_array, decimalToBinary(colours[6][0]), sizeof(r6_array));
    memcpy(g6_array, decimalToBinary(colours[6][1]), sizeof(g6_array));
    memcpy(b6_array, decimalToBinary(colours[6][2]), sizeof(b6_array));
    int r7_array[8]; //LED7
    int g7_array[8];
    int b7_array[8];
    memcpy(r7_array, decimalToBinary(colours[7][0]), sizeof(r7_array));
    memcpy(g7_array, decimalToBinary(colours[7][1]), sizeof(g7_array));
    memcpy(b7_array, decimalToBinary(colours[7][2]), sizeof(b7_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
    //set green bits
    spi.write(g0_array[7]); //set g7 bit
    spi.write(g0_array[6]); //set g6 bit
    spi.write(g0_array[5]); //set g5 bit
    spi.write(g0_array[4]); //set g4 bit
    spi.write(g0_array[3]); //set g3 bit
    spi.write(g0_array[2]); //set g2 bit
    spi.write(g0_array[1]); //set g1 bit 
    spi.write(g0_array[0]);//set g0 bit
    //set red bits
    spi.write(r0_array[7]);//set r7 bit
    spi.write(r0_array[6]); //set r6 bit
    spi.write(r0_array[5]); //set r5 bit
    spi.write(r0_array[4]); //set r4 bit
    spi.write(r0_array[3]); //set r3 bit
    spi.write(r0_array[2]); //set r2 bit
    spi.write(r0_array[1]); //set r1 bit 
    spi.write(r0_array[0]); //set r0 bit
    //set blue bits
    spi.write(b0_array[7]); //set b7 bit
    spi.write(b0_array[6]); //set b6 bit
    spi.write(b0_array[5]); //set b5 bit
    spi.write(b0_array[4]); //set b4 bit
    spi.write(b0_array[3]); //set b3 bit
    spi.write(b0_array[2]); //set b2 bit
    spi.write(b0_array[1]); //set b1 bit 
    spi.write(b0_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi.write(g1_array[7]); //set g7 bit
    spi.write(g1_array[6]); //set g6 bit
    spi.write(g1_array[5]); //set g5 bit
    spi.write(g1_array[4]); //set g4 bit
    spi.write(g1_array[3]); //set g3 bit
    spi.write(g1_array[2]); //set g2 bit
    spi.write(g1_array[1]); //set g1 bit 
    spi.write(g1_array[0]);//set g0 bit
    //set red bits
    spi.write(r1_array[7]);//set r7 bit
    spi.write(r1_array[6]); //set r6 bit
    spi.write(r1_array[5]); //set r5 bit
    spi.write(r1_array[4]); //set r4 bit
    spi.write(r1_array[3]); //set r3 bit
    spi.write(r1_array[2]); //set r2 bit
    spi.write(r1_array[1]); //set r1 bit 
    spi.write(r1_array[0]); //set r0 bit
    //set blue bits
    spi.write(b1_array[7]); //set b7 bit
    spi.write(b1_array[6]); //set b6 bit
    spi.write(b1_array[5]); //set b5 bit
    spi.write(b1_array[4]); //set b4 bit
    spi.write(b1_array[3]); //set b3 bit
    spi.write(b1_array[2]); //set b2 bit
    spi.write(b1_array[1]); //set b1 bit 
    spi.write(b1_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi.write(g2_array[7]); //set g7 bit
    spi.write(g2_array[6]); //set g6 bit
    spi.write(g2_array[5]); //set g5 bit
    spi.write(g2_array[4]); //set g4 bit
    spi.write(g2_array[3]); //set g3 bit
    spi.write(g2_array[2]); //set g2 bit
    spi.write(g2_array[1]); //set g1 bit 
    spi.write(g2_array[0]);//set g0 bit
    //set red bits
    spi.write(r2_array[7]);//set r7 bit
    spi.write(r2_array[6]); //set r6 bit
    spi.write(r2_array[5]); //set r5 bit
    spi.write(r2_array[4]); //set r4 bit
    spi.write(r2_array[3]); //set r3 bit
    spi.write(r2_array[2]); //set r2 bit
    spi.write(r2_array[1]); //set r1 bit 
    spi.write(r2_array[0]); //set r0 bit
    //set blue bits
    spi.write(b2_array[7]); //set b7 bit
    spi.write(b2_array[6]); //set b6 bit
    spi.write(b2_array[5]); //set b5 bit
    spi.write(b2_array[4]); //set b4 bit
    spi.write(b2_array[3]); //set b3 bit
    spi.write(b2_array[2]); //set b2 bit
    spi.write(b2_array[1]); //set b1 bit 
    spi.write(b2_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi.write(g3_array[7]); //set g7 bit
    spi.write(g3_array[6]); //set g6 bit
    spi.write(g3_array[5]); //set g5 bit
    spi.write(g3_array[4]); //set g4 bit
    spi.write(g3_array[3]); //set g3 bit
    spi.write(g3_array[2]); //set g2 bit
    spi.write(g3_array[1]); //set g1 bit 
    spi.write(g3_array[0]);//set g0 bit
    //set red bits
    spi.write(r3_array[7]);//set r7 bit
    spi.write(r3_array[6]); //set r6 bit
    spi.write(r3_array[5]); //set r5 bit
    spi.write(r3_array[4]); //set r4 bit
    spi.write(r3_array[3]); //set r3 bit
    spi.write(r3_array[2]); //set r2 bit
    spi.write(r3_array[1]); //set r1 bit 
    spi.write(r3_array[0]); //set r0 bit
    //set blue bits
    spi.write(b3_array[7]); //set b7 bit
    spi.write(b3_array[6]); //set b6 bit
    spi.write(b3_array[5]); //set b5 bit
    spi.write(b3_array[4]); //set b4 bit
    spi.write(b3_array[3]); //set b3 bit
    spi.write(b3_array[2]); //set b2 bit
    spi.write(b3_array[1]); //set b1 bit 
    spi.write(b3_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi.write(g4_array[7]); //set g7 bit
    spi.write(g4_array[6]); //set g6 bit
    spi.write(g4_array[5]); //set g5 bit
    spi.write(g4_array[4]); //set g4 bit
    spi.write(g4_array[3]); //set g3 bit
    spi.write(g4_array[2]); //set g2 bit
    spi.write(g4_array[1]); //set g1 bit 
    spi.write(g4_array[0]);//set g0 bit
    //set red bits
    spi.write(r4_array[7]);//set r7 bit
    spi.write(r4_array[6]); //set r6 bit
    spi.write(r4_array[5]); //set r5 bit
    spi.write(r4_array[4]); //set r4 bit
    spi.write(r4_array[3]); //set r3 bit
    spi.write(r4_array[2]); //set r2 bit
    spi.write(r4_array[1]); //set r1 bit 
    spi.write(r4_array[0]); //set r0 bit
    //set blue bits
    spi.write(b4_array[7]); //set b7 bit
    spi.write(b4_array[6]); //set b6 bit
    spi.write(b4_array[5]); //set b5 bit
    spi.write(b4_array[4]); //set b4 bit
    spi.write(b4_array[3]); //set b3 bit
    spi.write(b4_array[2]); //set b2 bit
    spi.write(b4_array[1]); //set b1 bit 
    spi.write(b4_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi.write(g5_array[7]); //set g7 bit
    spi.write(g5_array[6]); //set g6 bit
    spi.write(g5_array[5]); //set g5 bit
    spi.write(g5_array[4]); //set g4 bit
    spi.write(g5_array[3]); //set g3 bit
    spi.write(g5_array[2]); //set g2 bit
    spi.write(g5_array[1]); //set g1 bit 
    spi.write(g5_array[0]);//set g0 bit
    //set red bits
    spi.write(r5_array[7]);//set r7 bit
    spi.write(r5_array[6]); //set r6 bit
    spi.write(r5_array[5]); //set r5 bit
    spi.write(r5_array[4]); //set r4 bit
    spi.write(r5_array[3]); //set r3 bit
    spi.write(r5_array[2]); //set r2 bit
    spi.write(r5_array[1]); //set r1 bit 
    spi.write(r5_array[0]); //set r0 bit
    //set blue bits
    spi.write(b5_array[7]); //set b7 bit
    spi.write(b5_array[6]); //set b6 bit
    spi.write(b5_array[5]); //set b5 bit
    spi.write(b5_array[4]); //set b4 bit
    spi.write(b5_array[3]); //set b3 bit
    spi.write(b5_array[2]); //set b2 bit
    spi.write(b5_array[1]); //set b1 bit 
    spi.write(b5_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi.write(g6_array[7]); //set g7 bit
    spi.write(g6_array[6]); //set g6 bit
    spi.write(g6_array[5]); //set g5 bit
    spi.write(g6_array[4]); //set g4 bit
    spi.write(g6_array[3]); //set g3 bit
    spi.write(g6_array[2]); //set g2 bit
    spi.write(g6_array[1]); //set g1 bit 
    spi.write(g6_array[0]);//set g0 bit
    //set red bits
    spi.write(r6_array[7]);//set r7 bit
    spi.write(r6_array[6]); //set r6 bit
    spi.write(r6_array[5]); //set r5 bit
    spi.write(r6_array[4]); //set r4 bit
    spi.write(r6_array[3]); //set r3 bit
    spi.write(r6_array[2]); //set r2 bit
    spi.write(r6_array[1]); //set r1 bit 
    spi.write(r6_array[0]); //set r0 bit
    //set blue bits
    spi.write(b6_array[7]); //set b7 bit
    spi.write(b6_array[6]); //set b6 bit
    spi.write(b6_array[5]); //set b5 bit
    spi.write(b6_array[4]); //set b4 bit
    spi.write(b6_array[3]); //set b3 bit
    spi.write(b6_array[2]); //set b2 bit
    spi.write(b6_array[1]); //set b1 bit 
    spi.write(b6_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi.write(g7_array[7]); //set g7 bit
    spi.write(g7_array[6]); //set g6 bit
    spi.write(g7_array[5]); //set g5 bit
    spi.write(g7_array[4]); //set g4 bit
    spi.write(g7_array[3]); //set g3 bit
    spi.write(g7_array[2]); //set g2 bit
    spi.write(g7_array[1]); //set g1 bit 
    spi.write(g7_array[0]);//set g0 bit
    //set red bits
    spi.write(r7_array[7]);//set r7 bit
    spi.write(r7_array[6]); //set r6 bit
    spi.write(r7_array[5]); //set r5 bit
    spi.write(r7_array[4]); //set r4 bit
    spi.write(r7_array[3]); //set r3 bit
    spi.write(r7_array[2]); //set r2 bit
    spi.write(r7_array[1]); //set r1 bit 
    spi.write(r7_array[0]); //set r0 bit
    //set blue bits
    spi.write(b7_array[7]); //set b7 bit
    spi.write(b7_array[6]); //set b6 bit
    spi.write(b7_array[5]); //set b5 bit
    spi.write(b7_array[4]); //set b4 bit
    spi.write(b7_array[3]); //set b3 bit
    spi.write(b7_array[2]); //set b2 bit
    spi.write(b7_array[1]); //set b1 bit 
    spi.write(b7_array[0]); //set b0 bit
    //wait for latch
    wait_us(60);   
}

void neopixels_spi::setRGBPixels2(int colours[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    int r0_array[8]; //LED0
    int g0_array[8];
    int b0_array[8];
    memcpy(r0_array, decimalToBinary(colours[0][0]), sizeof(r0_array));
    memcpy(g0_array, decimalToBinary(colours[0][1]), sizeof(g0_array));
    memcpy(b0_array, decimalToBinary(colours[0][2]), sizeof(b0_array));
    int r1_array[8]; //LED1
    int g1_array[8];
    int b1_array[8];
    memcpy(r1_array, decimalToBinary(colours[1][0]), sizeof(r1_array));
    memcpy(g1_array, decimalToBinary(colours[1][1]), sizeof(g1_array));
    memcpy(b1_array, decimalToBinary(colours[1][2]), sizeof(b1_array));
    int r2_array[8]; //LED2
    int g2_array[8];
    int b2_array[8];
    memcpy(r2_array, decimalToBinary(colours[2][0]), sizeof(r2_array));
    memcpy(g2_array, decimalToBinary(colours[2][1]), sizeof(g2_array));
    memcpy(b2_array, decimalToBinary(colours[2][2]), sizeof(b2_array));
    int r3_array[8]; //LED3
    int g3_array[8];
    int b3_array[8];
    memcpy(r3_array, decimalToBinary(colours[3][0]), sizeof(r3_array));
    memcpy(g3_array, decimalToBinary(colours[3][1]), sizeof(g3_array));
    memcpy(b3_array, decimalToBinary(colours[3][2]), sizeof(b3_array));
    int r4_array[8]; //LED4
    int g4_array[8];
    int b4_array[8];
    memcpy(r4_array, decimalToBinary(colours[4][0]), sizeof(r4_array));
    memcpy(g4_array, decimalToBinary(colours[4][1]), sizeof(g4_array));
    memcpy(b4_array, decimalToBinary(colours[4][2]), sizeof(b4_array));
    int r5_array[8]; //LED5
    int g5_array[8];
    int b5_array[8];
    memcpy(r5_array, decimalToBinary(colours[5][0]), sizeof(r5_array));
    memcpy(g5_array, decimalToBinary(colours[5][1]), sizeof(g5_array));
    memcpy(b5_array, decimalToBinary(colours[5][2]), sizeof(b5_array));
    int r6_array[8]; //LED6
    int g6_array[8];
    int b6_array[8];
    memcpy(r6_array, decimalToBinary(colours[6][0]), sizeof(r6_array));
    memcpy(g6_array, decimalToBinary(colours[6][1]), sizeof(g6_array));
    memcpy(b6_array, decimalToBinary(colours[6][2]), sizeof(b6_array));
    int r7_array[8]; //LED7
    int g7_array[8];
    int b7_array[8];
    memcpy(r7_array, decimalToBinary(colours[7][0]), sizeof(r7_array));
    memcpy(g7_array, decimalToBinary(colours[7][1]), sizeof(g7_array));
    memcpy(b7_array, decimalToBinary(colours[7][2]), sizeof(b7_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
    //set green bits
    spi2.write(g0_array[7]); //set g7 bit
    spi2.write(g0_array[6]); //set g6 bit
    spi2.write(g0_array[5]); //set g5 bit
    spi2.write(g0_array[4]); //set g4 bit
    spi2.write(g0_array[3]); //set g3 bit
    spi2.write(g0_array[2]); //set g2 bit
    spi2.write(g0_array[1]); //set g1 bit 
    spi2.write(g0_array[0]);//set g0 bit
    //set red bits
    spi2.write(r0_array[7]);//set r7 bit
    spi2.write(r0_array[6]); //set r6 bit
    spi2.write(r0_array[5]); //set r5 bit
    spi2.write(r0_array[4]); //set r4 bit
    spi2.write(r0_array[3]); //set r3 bit
    spi2.write(r0_array[2]); //set r2 bit
    spi2.write(r0_array[1]); //set r1 bit 
    spi2.write(r0_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b0_array[7]); //set b7 bit
    spi2.write(b0_array[6]); //set b6 bit
    spi2.write(b0_array[5]); //set b5 bit
    spi2.write(b0_array[4]); //set b4 bit
    spi2.write(b0_array[3]); //set b3 bit
    spi2.write(b0_array[2]); //set b2 bit
    spi2.write(b0_array[1]); //set b1 bit 
    spi2.write(b0_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi2.write(g1_array[7]); //set g7 bit
    spi2.write(g1_array[6]); //set g6 bit
    spi2.write(g1_array[5]); //set g5 bit
    spi2.write(g1_array[4]); //set g4 bit
    spi2.write(g1_array[3]); //set g3 bit
    spi2.write(g1_array[2]); //set g2 bit
    spi2.write(g1_array[1]); //set g1 bit 
    spi2.write(g1_array[0]);//set g0 bit
    //set red bits
    spi2.write(r1_array[7]);//set r7 bit
    spi2.write(r1_array[6]); //set r6 bit
    spi2.write(r1_array[5]); //set r5 bit
    spi2.write(r1_array[4]); //set r4 bit
    spi2.write(r1_array[3]); //set r3 bit
    spi2.write(r1_array[2]); //set r2 bit
    spi2.write(r1_array[1]); //set r1 bit 
    spi2.write(r1_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b1_array[7]); //set b7 bit
    spi2.write(b1_array[6]); //set b6 bit
    spi2.write(b1_array[5]); //set b5 bit
    spi2.write(b1_array[4]); //set b4 bit
    spi2.write(b1_array[3]); //set b3 bit
    spi2.write(b1_array[2]); //set b2 bit
    spi2.write(b1_array[1]); //set b1 bit 
    spi2.write(b1_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi2.write(g2_array[7]); //set g7 bit
    spi2.write(g2_array[6]); //set g6 bit
    spi2.write(g2_array[5]); //set g5 bit
    spi2.write(g2_array[4]); //set g4 bit
    spi2.write(g2_array[3]); //set g3 bit
    spi2.write(g2_array[2]); //set g2 bit
    spi2.write(g2_array[1]); //set g1 bit 
    spi2.write(g2_array[0]);//set g0 bit
    //set red bits
    spi2.write(r2_array[7]);//set r7 bit
    spi2.write(r2_array[6]); //set r6 bit
    spi2.write(r2_array[5]); //set r5 bit
    spi2.write(r2_array[4]); //set r4 bit
    spi2.write(r2_array[3]); //set r3 bit
    spi2.write(r2_array[2]); //set r2 bit
    spi2.write(r2_array[1]); //set r1 bit 
    spi2.write(r2_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b2_array[7]); //set b7 bit
    spi2.write(b2_array[6]); //set b6 bit
    spi2.write(b2_array[5]); //set b5 bit
    spi2.write(b2_array[4]); //set b4 bit
    spi2.write(b2_array[3]); //set b3 bit
    spi2.write(b2_array[2]); //set b2 bit
    spi2.write(b2_array[1]); //set b1 bit 
    spi2.write(b2_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi2.write(g3_array[7]); //set g7 bit
    spi2.write(g3_array[6]); //set g6 bit
    spi2.write(g3_array[5]); //set g5 bit
    spi2.write(g3_array[4]); //set g4 bit
    spi2.write(g3_array[3]); //set g3 bit
    spi2.write(g3_array[2]); //set g2 bit
    spi2.write(g3_array[1]); //set g1 bit 
    spi2.write(g3_array[0]);//set g0 bit
    //set red bits
    spi2.write(r3_array[7]);//set r7 bit
    spi2.write(r3_array[6]); //set r6 bit
    spi2.write(r3_array[5]); //set r5 bit
    spi2.write(r3_array[4]); //set r4 bit
    spi2.write(r3_array[3]); //set r3 bit
    spi2.write(r3_array[2]); //set r2 bit
    spi2.write(r3_array[1]); //set r1 bit 
    spi2.write(r3_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b3_array[7]); //set b7 bit
    spi2.write(b3_array[6]); //set b6 bit
    spi2.write(b3_array[5]); //set b5 bit
    spi2.write(b3_array[4]); //set b4 bit
    spi2.write(b3_array[3]); //set b3 bit
    spi2.write(b3_array[2]); //set b2 bit
    spi2.write(b3_array[1]); //set b1 bit 
    spi2.write(b3_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi2.write(g4_array[7]); //set g7 bit
    spi2.write(g4_array[6]); //set g6 bit
    spi2.write(g4_array[5]); //set g5 bit
    spi2.write(g4_array[4]); //set g4 bit
    spi2.write(g4_array[3]); //set g3 bit
    spi2.write(g4_array[2]); //set g2 bit
    spi2.write(g4_array[1]); //set g1 bit 
    spi2.write(g4_array[0]);//set g0 bit
    //set red bits
    spi2.write(r4_array[7]);//set r7 bit
    spi2.write(r4_array[6]); //set r6 bit
    spi2.write(r4_array[5]); //set r5 bit
    spi2.write(r4_array[4]); //set r4 bit
    spi2.write(r4_array[3]); //set r3 bit
    spi2.write(r4_array[2]); //set r2 bit
    spi2.write(r4_array[1]); //set r1 bit 
    spi2.write(r4_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b4_array[7]); //set b7 bit
    spi2.write(b4_array[6]); //set b6 bit
    spi2.write(b4_array[5]); //set b5 bit
    spi2.write(b4_array[4]); //set b4 bit
    spi2.write(b4_array[3]); //set b3 bit
    spi2.write(b4_array[2]); //set b2 bit
    spi2.write(b4_array[1]); //set b1 bit 
    spi2.write(b4_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi2.write(g5_array[7]); //set g7 bit
    spi2.write(g5_array[6]); //set g6 bit
    spi2.write(g5_array[5]); //set g5 bit
    spi2.write(g5_array[4]); //set g4 bit
    spi2.write(g5_array[3]); //set g3 bit
    spi2.write(g5_array[2]); //set g2 bit
    spi2.write(g5_array[1]); //set g1 bit 
    spi2.write(g5_array[0]);//set g0 bit
    //set red bits
    spi2.write(r5_array[7]);//set r7 bit
    spi2.write(r5_array[6]); //set r6 bit
    spi2.write(r5_array[5]); //set r5 bit
    spi2.write(r5_array[4]); //set r4 bit
    spi2.write(r5_array[3]); //set r3 bit
    spi2.write(r5_array[2]); //set r2 bit
    spi2.write(r5_array[1]); //set r1 bit 
    spi2.write(r5_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b5_array[7]); //set b7 bit
    spi2.write(b5_array[6]); //set b6 bit
    spi2.write(b5_array[5]); //set b5 bit
    spi2.write(b5_array[4]); //set b4 bit
    spi2.write(b5_array[3]); //set b3 bit
    spi2.write(b5_array[2]); //set b2 bit
    spi2.write(b5_array[1]); //set b1 bit 
    spi2.write(b5_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi2.write(g6_array[7]); //set g7 bit
    spi2.write(g6_array[6]); //set g6 bit
    spi2.write(g6_array[5]); //set g5 bit
    spi2.write(g6_array[4]); //set g4 bit
    spi2.write(g6_array[3]); //set g3 bit
    spi2.write(g6_array[2]); //set g2 bit
    spi2.write(g6_array[1]); //set g1 bit 
    spi2.write(g6_array[0]);//set g0 bit
    //set red bits
    spi2.write(r6_array[7]);//set r7 bit
    spi2.write(r6_array[6]); //set r6 bit
    spi2.write(r6_array[5]); //set r5 bit
    spi2.write(r6_array[4]); //set r4 bit
    spi2.write(r6_array[3]); //set r3 bit
    spi2.write(r6_array[2]); //set r2 bit
    spi2.write(r6_array[1]); //set r1 bit 
    spi2.write(r6_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b6_array[7]); //set b7 bit
    spi2.write(b6_array[6]); //set b6 bit
    spi2.write(b6_array[5]); //set b5 bit
    spi2.write(b6_array[4]); //set b4 bit
    spi2.write(b6_array[3]); //set b3 bit
    spi2.write(b6_array[2]); //set b2 bit
    spi2.write(b6_array[1]); //set b1 bit 
    spi2.write(b6_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi2.write(g7_array[7]); //set g7 bit
    spi2.write(g7_array[6]); //set g6 bit
    spi2.write(g7_array[5]); //set g5 bit
    spi2.write(g7_array[4]); //set g4 bit
    spi2.write(g7_array[3]); //set g3 bit
    spi2.write(g7_array[2]); //set g2 bit
    spi2.write(g7_array[1]); //set g1 bit 
    spi2.write(g7_array[0]);//set g0 bit
    //set red bits
    spi2.write(r7_array[7]);//set r7 bit
    spi2.write(r7_array[6]); //set r6 bit
    spi2.write(r7_array[5]); //set r5 bit
    spi2.write(r7_array[4]); //set r4 bit
    spi2.write(r7_array[3]); //set r3 bit
    spi2.write(r7_array[2]); //set r2 bit
    spi2.write(r7_array[1]); //set r1 bit 
    spi2.write(r7_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b7_array[7]); //set b7 bit
    spi2.write(b7_array[6]); //set b6 bit
    spi2.write(b7_array[5]); //set b5 bit
    spi2.write(b7_array[4]); //set b4 bit
    spi2.write(b7_array[3]); //set b3 bit
    spi2.write(b7_array[2]); //set b2 bit
    spi2.write(b7_array[1]); //set b1 bit 
    spi2.write(b7_array[0]); //set b0 bit
    //wait for latch
    wait_us(60);   
}
int * neopixels_spi ::decimalToBinary(int n)  // converts decimal value to 8 bit array of 1's (0xFF0) and 0's (0xF00)
{
    int reminder;
    int i=0;
    int static binary[8]; //initialize to 00000000
    while (n!=0)
    {
        reminder=n%2;
        if(reminder == 1){
            binary[i] = 0xFF0;
        }
        if(reminder == 0){
            binary[i] = 0xF00;
        }
        n = n/2;
        i++;
    }
    //sets the remainder of the digits to 0xF00 if n reaches 0 before i = 7
    for(;i<8;i++){
        binary[i] = 0xF00;
    }   
    return binary;
}

void  neopixels_spi ::spi_init(){ //initializes spi port to send 0 bit length
     spi.format(14, 0); //set spi at 14 bits/byte with clock phase and clock polarity at mode 0 
     spi.frequency(10600000); //set frequency of spi clock at 96/9 - 10.6MHz 94.3 ns bit time length
     spi2.format(14, 0); //set spi at 14 bits/byte with clock phase and clock polarity at mode 0 
     spi2.frequency(10600000); //set frequency of spi clock at 96/9 - 10.6MHz 94.3 ns bit time length
     
    }
