#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>

Serial pc(USBTX, USBRX);

#define nrf_CE      D9
#define nrf_CSN     D10
#define spi_SCK     D3
#define spi_MOSI    D4
#define spi_MISO    D5

RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );

// Network uses that radio
RF24Network network(radio);

// Address of our node
const uint16_t this_node = 01;

// Address of the other node
const uint16_t other_node = 00;

// How often to send payload packet to the other unit
const unsigned long interval = 100; //ms

// When did we last send?
unsigned long last_sent;
Timer t;

// How many have we sent already
unsigned long packets_sent;
Timer t_packet;

// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
};


int main()
{
    pc.baud(921600);
    wait_ms(1000);

    pc.printf("mBed RF24Network node: Tx\n");
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    wait_ms(2000);
    t.start();
    t_packet.start();
    while(1) 
    {
        // Pump the network regularly
        network.update();

        /* If it's time to send a message, send it! */
        unsigned long now = t.read_ms();
        if ( now >= interval  ) 
        {
            t.reset();

            pc.printf("Sending...");
            payload_t payload_tx;
            payload_tx.ms = t_packet.read_ms();
            payload_tx.counter = packets_sent++;


            RF24NetworkHeader header_tx(/*to node*/ other_node);
            bool ok = network.write(header_tx,&payload_tx,sizeof(payload_tx));
            if (ok)
                pc.printf("ok.\n");
            else
                pc.printf("failed.\n");
        }


    }

}