#include "mbed.h"
#include "OneWire.h"

OneWire owBus(p21);

int main()
{
    char _id[16];
    DeviceAddresses* devAddresses = owBus.getFoundDevAddresses();
    uint8_t foundNum = owBus.getFoundDevNum();
    printf("OneWire: found %d devices\r\n", foundNum);

    while(1) {
        OneWireDeviceTemperature::startConversationForAll(&owBus, OWTEMP_11_BIT);
        for (uint8_t i = 0; i < foundNum; i++) {
            OneWireDevice* owDevice = OneWireDeviceFactory::init(&owBus, (*devAddresses)[i]);
            
            if (owDevice->getFamily() != ONEWIRE_DS18B20_FAMILY)    // currently only DS18B20 supports
                continue;

            owDevice->generateId(_id);
            printf("OneWire: device #%s = %.4f*C\r\n", _id, (float) owDevice->sendGetCommand(GET_TEMPERATURE));
            delete owDevice;            
        }
        
        wait(5);
    }
 }
