#include "mbed.h"
#include "BMP085.h"
#include <stdio.h>

#define Pu 76 //cmHg
#define Po 1009.789

float q=0.125,p=1.05728,r=10,k=0.10572799;

float toPa(float data)
{
    float hasil;
    hasil = data/100;
    return hasil;
}

Serial pc(USBTX,USBRX);
I2C i2c(p28,p27);
BMP085 alt_sensor(p28,p27);

float tekanan,tekanan_filter;
float ketinggian;

float average()
{
    float tekananx[50], rerata = 0;
    
    for (int i=0 ; i<50 ; i++)
    {
        tekananx[i]=alt_sensor.get_pressure();
        rerata = rerata +tekananx[i];
    }
    rerata = rerata / 50;
    return rerata;
}

int main()
{
    pc.baud(57600);
    while(1)
    {
        alt_sensor.update();
        tekanan=alt_sensor.get_pressure();
        p=p+q;
        k=p/(p+r);
        tekanan_filter=tekanan_filter+k*(tekanan-tekanan_filter);
        ketinggian = 44330*(1.0-pow(tekanan_filter/Po,0.1903));
        p=(1-k)*p;
        //ketinggian=alt_sensor.get_altitude_m();
        //pc.printf("%f||%f\n",ketinggian,tekanan);
        pc.printf("%f||%f\n",tekanan,ketinggian);
        wait_ms(100);
    }
}