#include "mbed.h"
#include "circularBuff.h"

Serial pc(USBTX,USBRX), rs485(p9,p10);
DigitalOut en(p19);

DigitalOut led1(LED1);
circ_buf_t buf1, buf2;
volatile bool buf1ready, buf2ready;

void rs485Rx_isr(){
    uint8_t a = rs485.getc();
    if(a != NULL)
        circ_buf_put(&buf1,a);
    else{
        circ_buf_put(&buf1,a);
        buf1ready=true;
    }
}

void rs485Tx_isr(){
    en=0;
}

void pcRx_isr(){
    uint8_t a = pc.getc();
    if(a != NULL)
        circ_buf_put(&buf2,a);
    else{
        circ_buf_put(&buf2,a);
        buf2ready=true;
    }
}

int main() {
    buf1.size=255;
    buf2.size=255;
    buf1.buffer=(uint8_t*)malloc(255);
    buf2.buffer=(uint8_t*)malloc(255);
    pc.printf("Hola");
    en=1;
    rs485.printf("Hola");
    pc.attach(&pcRx_isr,Serial::RxIrq);
    rs485.attach(&rs485Rx_isr,Serial::RxIrq);
    rs485.attach(&rs485Tx_isr,Serial::TxIrq);
    while(1) {
        if(buf2ready){
            en=1;
            uint8_t a=0;
            do{
            circ_buf_get(&buf2,&a);
            rs485.putc(a);    
            }while(a!=NULL);
            buf2ready=false;
        }
        if(buf1ready){
            uint8_t a=0;
            do{
            circ_buf_get(&buf1,&a);
            pc.putc(a);    
            }while(a!=NULL);
            buf1ready=false;
        }
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
}
