#include "mbed.h"
#include "HTTPServer.h"
#include "HTTPFS.h"
#include "HTTPDynamicPage.h"

#define MAX_DYNAMIC_CONTENT_LEN     2048
char dynamic_content[MAX_DYNAMIC_CONTENT_LEN];

const char content_fmt[] = 
"<HTML>"
"<HEAD>"
"<title>Dynamic Page</title>"
"</HEAD>"
"<BODY>"
"<H1>Hello World</H1>"
"<p>Page generated dynamically from code.</p>"
"<p>URL=%s</p>"
"<p>Header Fields=%s</p>"
"</BODY></HTML>"
;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

#define LED_ETH_LINK(val) do { led4=val; } while (0)

extern Ethernet eth;        // eth is defined elsewhere, avoid compiler error.
Serial pc(USBTX, USBRX);
Ticker eth_timer;

void eth_link_status() {
    static bool first = true;           // Avoid duplicate IP report on the very first pass
    static int eth_link = -1;           // Last state of eth link
    static unsigned int old_ip = 0;     // Last IP address
    int new_link = eth.link();
    if (eth_link != new_link) {
        if (new_link) {
            // From http://mbed.org/forum/post/909/
            NetServer *net = NetServer::get();
            struct ip_addr ip = net->getIPAddr();
//            struct ip_addr gw = net->getGateway();
//            struct ip_addr nm = net->getNetmask();
//            struct ip_addr dns = net->getDNS1();
            if (!first) printf("IP: %hhu.%hhu.%hhu.%hhu\r\n", (ip.addr)&0xFF, (ip.addr>>8)&0xFF, (ip.addr>>16)&0xFF, (ip.addr>>24)&0xFF);
            first = false;
            if (1 && ip.addr != old_ip) {
                // Create a link file to our IP.
                FILE *fp = fopen("/local/Start.url", "w");  // Create link to own IP
                if (fp) {
                    fprintf(fp, "[InternetShortcut]\r\nURL=http://%hhu.%hhu.%hhu.%hhu/\r\n", (ip.addr)&0xFF, (ip.addr>>8)&0xFF, (ip.addr>>16)&0xFF, (ip.addr>>24)&0xFF);
                    fclose(fp);
                    old_ip = ip.addr;
                }
            }
            
        }
        else {
            printf("IP: <link down>\r\n");
        }
        LED_ETH_LINK(new_link);
        eth_link = new_link;
    }
}

HTTPStatus myDynamicPage(HTTPConnection *con, HTTPDynamicPageData *pd) {
#if 0
    // Static example. With this, we don't really need HTTPStaticPage
    pd->size = 0;    // let it measure our page
    pd->page = (char*)content;    // Nothing dynamic about that yet, but we can now get loose here.
    pd->page_free = NULL;    // No mem free() needed
#elif 0
    // Dynamic example, static buffer
    pd->size = sprintf(dynamic_content, content_fmt, con->getURL(), con->getHeaderFields());
    pd->page = (char*)dynamic_content;
    pd->page_free = NULL;    // No mem free() needed
if(pd->size > sizeof(dynamic_content)) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#else
    // Dynamic example, dynamic buffer
    int size = sizeof(content_fmt) + 512;    // Just guess how much the data will expand
    char *buf = (char *)malloc(size);
    if (buf) {
        pd->size = sprintf(buf, content_fmt, con->getURL(), con->getHeaderFields());
        pd->page = buf;
        pd->page_free = &free;    // Use free() when done
if(pd->size > size) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#endif
    }
    return HTTP_OK;
}

int main(void) {
    char mac[6];

    led1=1;
    led2=1;
    led3=1;
    led4=1;

    char *hostname = "mbed";
    HTTPServer http(hostname);    // Use DHCP
    http.timeout(60000);    // Sets the timout for a HTTP request.  The timout is the time wich is allowed to spent between two incomming TCP packets.  If the time is passed the connection will be closed.

    eth.address(mac);
    pc.printf("\r\n\r\nHTTPServer \"%s\" started\r\nMAC %02X:%02X:%02X:%02X:%02X:%02X\r\n",
        hostname, mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

    led1=0;

    led2=0;

    http.addHandler(new HTTPDynamicPage("/dynamic.htm", &myDynamicPage));
    led3=0;

// FIXME: BUG If eth is not plugged, http.bind() hangs for awhile!
    http.bind();

    led4 = 0;
    eth_timer.attach(&eth_link_status, 0.1);
    while(1) {
        http.poll();    // Have to call this method at least every 250ms to let the http server run.
        wait(0.100);
    }
}

//END