#include "mbed.h"
#include "usbhost_inc.h"

void print_clock()
{
    int Fin = 12000000; // 12MHz XTAL
    
    printf("PLL Registers:\r\n");
    printf(" - PLL0STAT   = 0x%08X\r\n", LPC_SC->PLL0STAT);
    printf(" - CLKCFG     = 0x%08X\r\n", LPC_SC->CCLKCFG);
    printf(" - USBCLKCFG  = 0x%08X\r\n", LPC_SC->USBCLKCFG);
    
    int M = (LPC_SC->PLL0STAT & 0x7FFF) + 1;
    int N = ((LPC_SC->PLL0STAT >> 16) & 0xFF) + 1;
    int CCLKDIV = LPC_SC->CCLKCFG + 1;
    int USBDIV = LPC_SC->USBCLKCFG + 1;

    printf("Clock Variables:\r\n");
    printf(" - Fin = %d\r\n", Fin);
    printf(" - M   = %d\r\n", M);
    printf(" - N   = %d\r\n", N);
    printf(" - CCLKDIV = %d\r\n", CCLKDIV);
    printf(" - USBCLKDIV = %d\r\n", USBDIV);

    int Fcco = (2 * M * 12000000) / N;
    int CCLK = Fcco / CCLKDIV;

    printf("Clock Results:\r\n");    
    printf(" - Fcco = %d\r\n", Fcco);
    printf(" - CCLK = %d\r\n", CCLK);  
    printf(" - USB Clock = %d\r\n", Fcco / USBDIV);  
    printf("System clock: %d\r\n", SystemCoreClock);
}

/*
**************************************************************************************************************
*                                    COPYING A FILE
*
* Description: This function is used by the user to copy a file
*
* Arguments  : None
*
* Returns    : None
*
**************************************************************************************************************
*/

#define FILENAME_R "input.txt"
#define FILENAME_W "output.txt"
#define  MAX_BUFFER_SIZE             (4000)
void Main_Copy (void)
{
    USB_INT32S  fdr;
    USB_INT32S  fdw;
    USB_INT32U  bytes_read;


    fdr = FILE_Open((char *)FILENAME_R, RDONLY);
    if (fdr > 0) {
        fdw = FILE_Open((char *)FILENAME_W, RDWR);
        if (fdw > 0) {
            PRINT_Log("Copying from %s to %s...\r\n", FILENAME_R, FILENAME_W);
            do {
                bytes_read = FILE_Read(fdr, UserBuffer, MAX_BUFFER_SIZE);
                FILE_Write(fdw, UserBuffer, bytes_read);
                PRINT_Log(".");
            } while (bytes_read);
            PRINT_Log("\r\n");
            FILE_Close(fdw);
        } else {
            PRINT_Log("Could not open file %s\r\n", FILENAME_W);
            return;
        }
        FILE_Close(fdr);
        PRINT_Log("Copy completed\r\n");
    } else {
        PRINT_Log("Could not open file %s\r\n", FILENAME_R);
        return;
    }
}

int main()
{
    USB_INT32S  rc;
    USB_INT32U  numBlks, blkSize;
    USB_INT08U  inquiryResult[INQUIRY_LENGTH];
    
    print_clock();
//    UART_Init(115200);         /* Initialize the serial port to view the log messages                       */
    Host_Init();               /* Initialize the  host controller                                    */
    rc = Host_EnumDev();       /* Enumerate the device connected                                            */
    if (rc == OK) {
        /* Initialize the mass storage and scsi interfaces */
        rc = MS_Init( &blkSize, &numBlks, inquiryResult );
        if (rc == OK) {
            rc = FAT_Init();   /* Initialize the FAT16 file system                                          */
            if (rc == OK) {
                Main_Copy();   /* Call the application                                                      */
            } else {
printf("ERROR %d in FAT_Init()\r\n", rc);
                while ( 1 );
            //    return (0);
            }
printf("All OK in main()\r\n");
        } else {
printf("ERROR %d in MS_Init()\r\n", rc);
            while ( 1 );
//            return (0);
        }
    } else {                            
printf("ERROR %d in Host_EnumDev()\r\n", rc);
        while ( 1 );
//        return (0);
    }
    while(1);
}
