/*
**************************************************************************************************************
*                                                 NXP USB Host Stack
*
*                                     (c) Copyright 2008, NXP SemiConductors
*                                     (c) Copyright 2008, OnChip  Technologies LLC
*                                                 All Rights Reserved
*
*                                                  www.nxp.com
*                                               www.onchiptech.com
*
* File           : usbhost_inc.h
* Programmer(s)  : Ravikanth.P
* Version        :
*
**************************************************************************************************************
*/

#ifndef  USBHOST_INC_H
#define  USBHOST_INC_H

/*
**************************************************************************************************************
*                                       INCLUDE HEADER FILES
**************************************************************************************************************
*/

#include  "usbhost_cpu.h"
#include  "usbhost_err.h"
//#include  "Uart/usbhost_uart.h"
#include  "Host/usbhost_lpc17xx.h"
#include  "MassStorage/usbhost_ms.h"
#include  "Fat/usbhost_fat.h"
//#include  "LPC17xx.h"
#include  "mbed.h"

#ifdef TARGET_LPC2368
// [iva2k]

// fix for bad define in LPC23xx.h
#if LPC_USB_BASE != 0xFFE0C000
#undef LPC_USB_BASE
#define LPC_USB_BASE 0xFFE0C000
#define LPC_USB ((LPC_USB_TypeDef *)LPC_USB_BASE)
#endif

#endif

#ifdef TARGET_LPC2368
static __INLINE void NVIC_SetPriority(IRQn_Type IRQn, uint32_t priority)
{
  NVIC->VectPriority[(uint32_t)(IRQn)] = ((priority) & (1 << __NVIC_PRIO_BITS -1 ) ); 
}
#endif
#endif
