
/*
Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "FSHandler.h"

//#define __DEBUG
#include "dbg/dbg.h"

#define CHUNK_SIZE 512//128

//LocalFileSystem local("webfs");
//LocalFileSystem FSHandler_fs("webfs");

FSHandler::FSHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket), m_err404(false)
{}

FSHandler::~FSHandler()
{
  if(m_fp)
    fclose(m_fp);
  DBG("Handler destroyed\r\n");
}

void FSHandler::doGet()
{
  DBG("In FSHandler::doGet()\r\n");
  //FIXME: Translate path to local/path
  m_fp = fopen(path().c_str(), "r"); //FIXME: if null, error 404
  
  if(!m_fp)
  {
    m_err404 = true;
    setErrCode(404);
    const char* msg = "File not found.";
    setContentLen(strlen(msg));
    respHeaders()["Content-Type"] = "text/html";
    respHeaders()["Connection"] = "close";
    writeData(msg,strlen(msg)); //Only send header
    DBG("Exit SimpleHandler::doGet() w Error 404\r\n");
    return;
  }
    
  //Seek EOF to get length
  fseek(m_fp, 0, SEEK_END);
  setContentLen( ftell(m_fp) );
  fseek(m_fp, 0, SEEK_SET); //Goto SOF

  respHeaders()["Connection"] = "close";
  onWriteable();
  DBG("Exit SimpleHandler::doGet()\r\n");
}

void FSHandler::doPost()
{

}

void FSHandler::doHead()
{

}

void FSHandler::onReadable() //Data has been read
{

}

void FSHandler::onWriteable() //Data has been written & buf is free
{
  DBG("FSHandler::onWriteable() event\r\n");
  if(m_err404)
  {
    //Error has been served, now exit
    close();
    return;
  }
  
  static char rBuf[CHUNK_SIZE];
  int len = fread(rBuf, 1, CHUNK_SIZE, m_fp);
  if(len>0)
  {
    writeData(rBuf, len);
  }
  else
  {
    close(); //Data written, we can close the connection
  }
}

void FSHandler::onClose() //Connection is closing
{
  if(m_fp)
    fclose(m_fp);
}
